/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestCaseResult;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresultinterface.LogFileXmlHandler;
import org.testtoolinterfaces.testresultinterface.TestStepSequenceResultXmlHandler;
import org.testtoolinterfaces.testsuite.TestCase;
import org.testtoolinterfaces.testsuite.TestCaseImpl;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

public class TestCaseResultXmlHandler
extends XmlHandler {
    public static final String START_ELEMENT = "testcase";
    public static final String ELEMENT_ID = "id";
    public static final String ELEMENT_SEQUENCE = "sequence";
    private String myTestCaseId;
    private int mySequence;
    private String myDescription;
    private ArrayList<String> myRequirements;
    private TestResult.VERDICT myResult;
    private String myComment;
    private Hashtable<String, String> myLogFiles;
    private ArrayList<TestStepResult> myPrepareSteps;
    private ArrayList<TestStepResult> myExecutionSteps;
    private ArrayList<TestStepResult> myRestoreSteps;
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String ELEMENT_REQUIREMENT = "requirement";
    private static final String PREPARE_ELEMENT = "prepare";
    private static final String EXECUTE_ELEMENT = "execute";
    private static final String RESTORE_ELEMENT = "restore";
    private static final String RESULT_ELEMENT = "result";
    private static final String COMMENT_ELEMENT = "comment";
    private GenericTagAndStringXmlHandler myDescriptionXmlHandler;
    private GenericTagAndStringXmlHandler myRequirementIdXmlHandler;
    private TestStepSequenceResultXmlHandler myPrepareResultXmlHandler;
    private TestStepSequenceResultXmlHandler myExecutionResultXmlHandler;
    private TestStepSequenceResultXmlHandler myRestoreResultXmlHandler;
    private GenericTagAndStringXmlHandler myResultXmlHandler;
    private LogFileXmlHandler myLogFileXmlHandler;
    private GenericTagAndStringXmlHandler myCommentXmlHandler;

    public TestCaseResultXmlHandler(XMLReader anXmlReader, TestInterfaceList anInterfaceList) {
        super(anXmlReader, START_ELEMENT);
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR);
        this.reset();
        this.myDescriptionXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, DESCRIPTION_ELEMENT);
        this.addElementHandler(DESCRIPTION_ELEMENT, (XmlHandler)this.myDescriptionXmlHandler);
        this.myRequirementIdXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_REQUIREMENT);
        this.addElementHandler(ELEMENT_REQUIREMENT, (XmlHandler)this.myRequirementIdXmlHandler);
        this.myPrepareResultXmlHandler = new TestStepSequenceResultXmlHandler(anXmlReader, PREPARE_ELEMENT, anInterfaceList);
        this.addElementHandler(PREPARE_ELEMENT, this.myPrepareResultXmlHandler);
        this.myExecutionResultXmlHandler = new TestStepSequenceResultXmlHandler(anXmlReader, EXECUTE_ELEMENT, anInterfaceList);
        this.addElementHandler(EXECUTE_ELEMENT, this.myExecutionResultXmlHandler);
        this.myRestoreResultXmlHandler = new TestStepSequenceResultXmlHandler(anXmlReader, RESTORE_ELEMENT, anInterfaceList);
        this.addElementHandler(RESTORE_ELEMENT, this.myRestoreResultXmlHandler);
        this.myResultXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, RESULT_ELEMENT);
        this.addElementHandler(RESULT_ELEMENT, (XmlHandler)this.myResultXmlHandler);
        this.myLogFileXmlHandler = new LogFileXmlHandler(anXmlReader);
        this.addElementHandler("logfile", (XmlHandler)this.myLogFileXmlHandler);
        this.myCommentXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, COMMENT_ELEMENT);
        this.addElementHandler(COMMENT_ELEMENT, (XmlHandler)this.myCommentXmlHandler);
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
        Trace.print((Trace.LEVEL)Trace.SUITE, (String)("processElementAttributes( " + aQualifiedName), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase(START_ELEMENT)) {
            for (int i = 0; i < att.getLength(); ++i) {
                Trace.print((Trace.LEVEL)Trace.SUITE, (String)(", " + att.getQName(i) + "=" + att.getValue(i)));
                if (att.getQName(i).equalsIgnoreCase(ELEMENT_ID)) {
                    this.myTestCaseId = att.getValue(i);
                }
                if (!att.getQName(i).equalsIgnoreCase(ELEMENT_SEQUENCE)) continue;
                this.mySequence = Integer.valueOf(att.getValue(i));
            }
        }
        Trace.println((Trace.LEVEL)Trace.SUITE, (String)" )");
    }

    public TestCaseResult getTestCaseResult() throws SAXParseException {
        int key;
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (this.myTestCaseId.isEmpty()) {
            throw new SAXParseException("Unknown TestCase ID", new LocatorImpl());
        }
        TestCaseImpl testCase = new TestCaseImpl(this.myTestCaseId, this.myDescription, 0, this.myRequirements, null, null, null, new Hashtable(), new Hashtable());
        TestCaseResult testCaseResult = new TestCaseResult((TestCase)testCase);
        testCaseResult.setResult(this.myResult);
        testCaseResult.setComment(this.myComment);
        if (!this.myLogFiles.isEmpty()) {
            Enumeration<String> keys = this.myLogFiles.keys();
            while (keys.hasMoreElements()) {
                String key2 = keys.nextElement();
                testCaseResult.addTestLog(key2, this.myLogFiles.get(key2));
            }
        }
        for (key = 0; key < this.myPrepareSteps.size(); ++key) {
            testCaseResult.addInitialization(this.myPrepareSteps.get(key));
        }
        for (key = 0; key < this.myExecutionSteps.size(); ++key) {
            testCaseResult.addExecution(this.myExecutionSteps.get(key));
        }
        for (key = 0; key < this.myRestoreSteps.size(); ++key) {
            testCaseResult.addRestore(this.myRestoreSteps.get(key));
        }
        return testCaseResult;
    }

    public int getSequence() {
        Trace.println((Trace.LEVEL)Trace.GETTER, (String)("getSequence() -> " + this.mySequence), (boolean)true);
        return this.mySequence;
    }

    public void reset() {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        this.myTestCaseId = "";
        this.mySequence = 0;
        this.myDescription = "";
        this.myRequirements = new ArrayList();
        this.myResult = TestResult.UNKNOWN;
        this.myComment = "";
        this.myLogFiles = new Hashtable();
        this.myPrepareSteps = new ArrayList();
        this.myExecutionSteps = new ArrayList();
        this.myRestoreSteps = new ArrayList();
    }

    public void handleStartElement(String aQualifiedName) {
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (aQualifiedName.equalsIgnoreCase(DESCRIPTION_ELEMENT)) {
            this.myDescription = this.myDescriptionXmlHandler.getValue();
            this.myDescriptionXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(ELEMENT_REQUIREMENT)) {
            this.myRequirements.add(this.myRequirementIdXmlHandler.getValue());
            this.myRequirementIdXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(PREPARE_ELEMENT)) {
            this.myPrepareSteps = this.myPrepareResultXmlHandler.getStepSequence();
            this.myPrepareResultXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(EXECUTE_ELEMENT)) {
            this.myExecutionSteps = this.myExecutionResultXmlHandler.getStepSequence();
            this.myExecutionResultXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(RESTORE_ELEMENT)) {
            this.myRestoreSteps = this.myRestoreResultXmlHandler.getStepSequence();
            this.myRestoreResultXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(RESULT_ELEMENT)) {
            this.myResult = TestResult.VERDICT.valueOf((String)this.myResultXmlHandler.getValue().toUpperCase());
            this.myResultXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase(COMMENT_ELEMENT)) {
            this.myComment = this.myCommentXmlHandler.getValue();
            this.myCommentXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("logfile")) {
            this.myLogFiles.put(this.myLogFileXmlHandler.getType(), this.myLogFileXmlHandler.getValue());
            this.myLogFileXmlHandler.reset();
        }
    }
}

