/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.ResultSummary;
import org.testtoolinterfaces.testresult.TestCaseResultLink;
import org.testtoolinterfaces.testresult.TestGroupResult;
import org.testtoolinterfaces.testresult.TestGroupResultLink;
import org.testtoolinterfaces.testresult.TestGroupResultObserver;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresultinterface.Configuration;
import org.testtoolinterfaces.testresultinterface.TestGroupResultWriter;
import org.testtoolinterfaces.testresultinterface.TestStepResultXmlWriter;
import org.testtoolinterfaces.testresultinterface.XmlWriterUtils;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGroupResultXmlWriter
implements TestGroupResultWriter {
    private File myXslDir;
    private Hashtable<String, File> myResultFiles;
    private TestStepResultXmlWriter myTsResultWriter;

    public TestGroupResultXmlWriter(Configuration aConfiguration) {
        Trace.println((Trace.LEVEL)Trace.CONSTRUCTOR, (String)"TestGroupResultXmlWriter( aConfiguration )", (boolean)true);
        this.myXslDir = aConfiguration.getGroupXslDir();
        if (this.myXslDir == null) {
            throw new Error("No directory specified.");
        }
        if (!this.myXslDir.isDirectory()) {
            throw new Error("Not a directory: " + this.myXslDir.getPath());
        }
        this.myResultFiles = new Hashtable();
        this.myTsResultWriter = new TestStepResultXmlWriter();
    }

    @Override
    public void write(TestGroupResult aTestGroupResult, File aResultFile) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("write( " + aResultFile.getPath() + " )"), (boolean)true);
        if (aTestGroupResult == null) {
            return;
        }
        this.myResultFiles.put(aTestGroupResult.getId(), aResultFile);
        this.writeToFile(aTestGroupResult, aResultFile);
        aTestGroupResult.register((TestGroupResultObserver)this);
    }

    public void notify(TestGroupResult aTestGroupResult) {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("notify( " + aTestGroupResult.getId() + " )"), (boolean)true);
        File resultFile = this.myResultFiles.get(aTestGroupResult.getId());
        if (resultFile == null) {
            Warning.println((String)"Cannot update a test group file that is not yet written");
        } else {
            this.writeToFile(aTestGroupResult, resultFile);
        }
    }

    private void writeToFile(TestGroupResult aTestGroupResult, File aResultFile) {
        File logDir = aResultFile.getParentFile();
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        XmlWriterUtils.copyXsl(this.myXslDir, logDir);
        try {
            FileWriter xmlFile = new FileWriter(aResultFile);
            XmlWriterUtils.printXmlDeclaration(xmlFile, "testgroup.xsl");
            xmlFile.write("<testgroup\n");
            xmlFile.write("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            xmlFile.write("    xsi:noNamespaceSchemaLocation=\"TestResult_Group.xsd\"\n");
            xmlFile.write("    xsdMain='0'\n");
            xmlFile.write("    xsdSub='2'\n");
            xmlFile.write("    xsdPatch='0'\n");
            xmlFile.write("    id='" + aTestGroupResult.getId() + "'\n");
            xmlFile.write(">\n");
            xmlFile.write("  <prepare>\n");
            this.printStepResults(xmlFile, aTestGroupResult.getPrepareResults(), logDir);
            xmlFile.write("  </prepare>\n");
            this.printTestGroupLinks(aTestGroupResult, xmlFile, "", logDir);
            this.printTestCaseLinks(aTestGroupResult, xmlFile, "", logDir);
            xmlFile.write("  <restore>\n");
            this.printStepResults(xmlFile, aTestGroupResult.getRestoreResults(), logDir);
            xmlFile.write("  </restore>\n");
            XmlWriterUtils.printXmlLogFiles(aTestGroupResult.getLogs(), xmlFile, logDir.getAbsolutePath(), "  ");
            this.printSummary(xmlFile, aTestGroupResult.getSummary(), "  ");
            xmlFile.write("</testgroup>\n");
            xmlFile.flush();
        }
        catch (IOException exception) {
            Warning.println((String)("Saving Test Group Result XML failed: " + exception.getMessage()));
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)exception);
        }
    }

    public void printXml(TestGroupResult aTestGroupResult, OutputStreamWriter aStream, String anIndent, File aLogDir) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("printXml( " + aTestGroupResult.getId() + " )"), (boolean)true);
        aStream.write(anIndent + "<testgroup");
        aStream.write(" id='" + aTestGroupResult.getId() + "'");
        aStream.write(">\n");
        aStream.write("  <prepare>\n");
        this.printStepResults(aStream, aTestGroupResult.getPrepareResults(), aLogDir);
        aStream.write("  </prepare>\n");
        this.printTestGroupLinks(aTestGroupResult, aStream, anIndent, aLogDir);
        this.printTestCaseLinks(aTestGroupResult, aStream, anIndent, aLogDir);
        aStream.write("  <restore>\n");
        this.printStepResults(aStream, aTestGroupResult.getRestoreResults(), aLogDir);
        aStream.write("  </restore>\n");
        XmlWriterUtils.printXmlLogFiles(aTestGroupResult.getLogs(), aStream, aLogDir.getAbsolutePath(), anIndent + "  ");
        this.printSummary(aStream, aTestGroupResult.getSummary(), anIndent + "  ");
        aStream.write(anIndent + "</testgroup>\n");
        aStream.flush();
    }

    private void printTestCaseLinks(TestGroupResult aTestGroupResult, OutputStreamWriter aStream, String anIndent, File aLogDir) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("printTestCaseLinks( " + aTestGroupResult.getId() + ", " + "aStream, " + anIndent + ", " + aLogDir.getPath() + " )"), (boolean)true);
        Hashtable tcResults = aTestGroupResult.getTestCaseResultLinks();
        for (int key = 0; key < tcResults.size(); ++key) {
            TestCaseResultLink tcResultLink = (TestCaseResultLink)tcResults.get(key);
            aStream.write(anIndent + "  <testcaselink");
            aStream.write(" id='" + tcResultLink.getId() + "'");
            aStream.write(" type='" + tcResultLink.getType() + "'");
            aStream.write(" sequence='" + tcResultLink.getSequenceNr() + "'");
            aStream.write(">\n");
            aStream.write(anIndent + "    <link>");
            String tcLink = tcResultLink.getLink().getAbsolutePath();
            String relativeTcLink = XmlWriterUtils.makeFileRelative(tcLink, aLogDir.getAbsolutePath());
            aStream.write(relativeTcLink);
            aStream.write("</link>\n");
            aStream.write(anIndent + "    <verdict>");
            aStream.write(tcResultLink.getResult().toString());
            aStream.write("</verdict>\n");
            aStream.write(anIndent + "    <comment>");
            aStream.write(tcResultLink.getComment());
            aStream.write("</comment>\n");
            aStream.write(anIndent + "  </testcaselink>\n");
        }
    }

    private void printTestGroupLinks(TestGroupResult aTestGroupResult, OutputStreamWriter aStream, String anIndent, File aLogDir) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("printTestGroupLinks( " + aTestGroupResult.getId() + ", " + "aStream, " + anIndent + " )"), (boolean)true);
        Hashtable tgResults = aTestGroupResult.getTestGroupResultLinks();
        for (int key = 0; key < tgResults.size(); ++key) {
            TestGroupResultLink tgResult = (TestGroupResultLink)tgResults.get(key);
            aStream.write(anIndent + "  <testgrouplink");
            aStream.write(" id='" + tgResult.getId() + "'");
            aStream.write(" type='" + tgResult.getType() + "'");
            aStream.write(" sequence='" + tgResult.getSequenceNr() + "'");
            aStream.write(">\n");
            File tgLink = tgResult.getLink();
            if (tgLink != null) {
                aStream.write(anIndent + "    <link>");
                String tgLinkString = tgLink.getAbsolutePath();
                String relativeTgLink = XmlWriterUtils.makeFileRelative(tgLinkString, aLogDir.getAbsolutePath());
                aStream.write(relativeTgLink);
                aStream.write("</link>\n");
            }
            ResultSummary summary = ((TestGroupResultLink)tgResults.get(key)).getSummary();
            this.printSummary(aStream, summary, anIndent + "    ");
            aStream.write(anIndent + "  </testgrouplink>\n");
        }
    }

    private void printStepResults(OutputStreamWriter aStream, Hashtable<Integer, TestStepResult> aStepResults, File aLogDir) throws IOException {
        for (int key = 0; key < aStepResults.size(); ++key) {
            this.myTsResultWriter.printXml(aStepResults.get(key), aStream, aLogDir);
        }
    }

    private void printSummary(OutputStreamWriter aStream, ResultSummary aSummary, String anIndent) throws IOException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("printSummary( aStream, aSummary, " + anIndent + " )"), (boolean)true);
        aStream.write(anIndent + "<summary>\n");
        aStream.write(anIndent + "  <totaltestcases>");
        aStream.write(Integer.valueOf(aSummary.getNrOfTCs()).toString());
        aStream.write("</totaltestcases>\n");
        aStream.write(anIndent + "  <totalpassed>");
        aStream.write(Integer.valueOf(aSummary.getNrOfTCsPassed()).toString());
        aStream.write("</totalpassed>\n");
        aStream.write(anIndent + "  <totalfailed>");
        aStream.write(Integer.valueOf(aSummary.getNrOfTCsFailed()).toString());
        aStream.write("</totalfailed>\n");
        aStream.write(anIndent + "  <totalunknown>");
        aStream.write(Integer.valueOf(aSummary.getNrOfTCsUnknown()).toString());
        aStream.write("</totalunknown>\n");
        aStream.write(anIndent + "  <totalerror>");
        aStream.write(Integer.valueOf(aSummary.getNrOfTCsError()).toString());
        aStream.write("</totalerror>\n");
        aStream.write(anIndent + "</summary>\n");
    }
}

