/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.TestCaseResultLink;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testsuite.TestCaseLink;
import org.testtoolinterfaces.testsuite.TestLink;
import org.testtoolinterfaces.testsuite.TestLinkImpl;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class TestCaseResultLinkXmlHandler
extends XmlHandler {
    public static final String ELEMENT_START = "testcaselink";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_SEQUENCE = "sequence";
    private static final String ELEMENT_LINK = "link";
    private static final String ELEMENT_VERDICT = "verdict";
    private String myTestCaseId;
    private String myType;
    private int mySequence;
    private File myTcLink;
    private TestResult.VERDICT myResult;
    private GenericTagAndStringXmlHandler myTestCaseLinkXmlHandler;
    private GenericTagAndStringXmlHandler myVerdictXmlHandler;

    public TestCaseResultLinkXmlHandler(XMLReader anXmlReader) {
        super(anXmlReader, ELEMENT_START);
        this.reset();
        this.myTestCaseLinkXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_LINK);
        this.addElementHandler(ELEMENT_LINK, (XmlHandler)this.myTestCaseLinkXmlHandler);
        this.myVerdictXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_VERDICT);
        this.addElementHandler(ELEMENT_VERDICT, (XmlHandler)this.myVerdictXmlHandler);
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (aQualifiedName.equalsIgnoreCase(ELEMENT_LINK)) {
            this.myTcLink = new File(this.myTestCaseLinkXmlHandler.getValue());
            this.myTestCaseLinkXmlHandler.reset();
        }
        if (aQualifiedName.equalsIgnoreCase(ELEMENT_VERDICT)) {
            this.myResult = TestResult.VERDICT.valueOf((String)this.myVerdictXmlHandler.getValue().toUpperCase());
            this.myVerdictXmlHandler.reset();
        }
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
        Trace.print((Trace.LEVEL)Trace.SUITE, (String)("processElementAttributes( " + aQualifiedName + ", attributes )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase("testgroup")) {
            for (int i = 0; i < att.getLength(); ++i) {
                Trace.print((Trace.LEVEL)Trace.SUITE, (String)(", " + att.getQName(i) + "=" + att.getValue(i)));
                if (att.getQName(i).equalsIgnoreCase(ATTRIBUTE_ID)) {
                    this.myTestCaseId = att.getValue(i);
                    continue;
                }
                if (att.getQName(i).equalsIgnoreCase(ATTRIBUTE_TYPE)) {
                    this.myType = att.getValue(i);
                    continue;
                }
                if (!att.getQName(i).equalsIgnoreCase(ATTRIBUTE_SEQUENCE)) continue;
                this.mySequence = Integer.valueOf(att.getValue(i));
            }
        }
        Trace.println((Trace.LEVEL)Trace.SUITE, (String)" )");
    }

    public TestCaseResultLink getTestCaseResultLink() {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        TestCaseLink tcLink = new TestCaseLink(this.myTestCaseId, this.mySequence, (TestLink)new TestLinkImpl("unknown", this.myType), new Hashtable(), new Hashtable());
        TestCaseResultLink tcResultLink = new TestCaseResultLink(tcLink, this.myResult, this.myTcLink);
        return tcResultLink;
    }

    public void reset() {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        this.myTestCaseId = "";
        this.myType = "";
        this.mySequence = 0;
        this.myTcLink = new File("unknown");
        this.myResult = TestResult.VERDICT.UNKNOWN;
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleStartElement(String aQualifiedName) {
    }
}

