/*
 * Decompiled with CFR 0.152.
 */
package org.testtoolinterfaces.testresultinterface;

import java.io.File;
import java.util.Hashtable;
import org.testtoolinterfaces.testresult.ResultSummary;
import org.testtoolinterfaces.testresult.TestGroupResultLink;
import org.testtoolinterfaces.testresultinterface.SummaryResultXmlHandler;
import org.testtoolinterfaces.testsuite.TestGroupLink;
import org.testtoolinterfaces.testsuite.TestLink;
import org.testtoolinterfaces.testsuite.TestLinkImpl;
import org.testtoolinterfaces.utils.GenericTagAndStringXmlHandler;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class TestGroupResultLinkXmlHandler
extends XmlHandler {
    public static final String ELEMENT_START = "testgrouplink";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_SEQUENCE = "sequence";
    private static final String ELEMENT_LINK = "link";
    private String myTestGroupId;
    private String myType;
    private int mySequence;
    private File myTgResultLink;
    private ResultSummary myResult;
    private GenericTagAndStringXmlHandler myTestGroupLinkXmlHandler;
    private SummaryResultXmlHandler mySummaryXmlHandler;

    public TestGroupResultLinkXmlHandler(XMLReader anXmlReader) {
        super(anXmlReader, ELEMENT_START);
        this.reset();
        this.myTestGroupLinkXmlHandler = new GenericTagAndStringXmlHandler(anXmlReader, ELEMENT_LINK);
        this.addElementHandler(ELEMENT_LINK, (XmlHandler)this.myTestGroupLinkXmlHandler);
        this.mySummaryXmlHandler = new SummaryResultXmlHandler(anXmlReader);
        this.addElementHandler("summary", this.mySummaryXmlHandler);
    }

    public void handleReturnFromChildElement(String aQualifiedName, XmlHandler aChildXmlHandler) {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        if (aQualifiedName.equalsIgnoreCase(ELEMENT_LINK)) {
            this.myTgResultLink = new File(this.myTestGroupLinkXmlHandler.getValue());
            this.myTestGroupLinkXmlHandler.reset();
        } else if (aQualifiedName.equalsIgnoreCase("summary")) {
            this.myResult = this.mySummaryXmlHandler.getSummary();
            this.mySummaryXmlHandler.reset();
        }
    }

    public void processElementAttributes(String aQualifiedName, Attributes att) {
        Trace.print((Trace.LEVEL)Trace.SUITE, (String)("processElementAttributes( " + aQualifiedName + ", attributes )"), (boolean)true);
        if (aQualifiedName.equalsIgnoreCase("testgroup")) {
            for (int i = 0; i < att.getLength(); ++i) {
                Trace.print((Trace.LEVEL)Trace.SUITE, (String)(", " + att.getQName(i) + "=" + att.getValue(i)));
                if (att.getQName(i).equalsIgnoreCase(ATTRIBUTE_ID)) {
                    this.myTestGroupId = att.getValue(i);
                    continue;
                }
                if (att.getQName(i).equalsIgnoreCase(ATTRIBUTE_TYPE)) {
                    this.myType = att.getValue(i);
                    continue;
                }
                if (!att.getQName(i).equalsIgnoreCase(ATTRIBUTE_SEQUENCE)) continue;
                this.mySequence = Integer.valueOf(att.getValue(i));
            }
        }
        Trace.println((Trace.LEVEL)Trace.SUITE, (String)" )");
    }

    public TestGroupResultLink getTestGroupResultLink() {
        Trace.println((Trace.LEVEL)Trace.SUITE);
        TestGroupLink tgLink = new TestGroupLink(this.myTestGroupId, this.mySequence, (TestLink)new TestLinkImpl("unknown", this.myType), new Hashtable(), new Hashtable());
        TestGroupResultLink tgResultLink = new TestGroupResultLink(tgLink, this.myResult, this.myTgResultLink);
        return tgResultLink;
    }

    public void reset() {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        this.myTestGroupId = "";
        this.myType = "";
        this.mySequence = 0;
        this.myTgResultLink = new File("unknown");
        this.myResult = new ResultSummary(0, 0, 0, 0);
    }

    public void handleCharacters(String aValue) {
    }

    public void handleEndElement(String aQualifiedName) {
    }

    public void handleGoToChildElement(String aQualifiedName) {
    }

    public void handleStartElement(String aQualifiedName) {
    }
}

