/*
 * Decompiled with CFR 0.152.
 */
package org.thethingsnetwork.management;

import com.google.protobuf.ByteString;
import org.thethingsnetwork.management.proto.DeviceOuterClass;
import rx.Observable;

public class LorawanDevice {
    private byte[] appEui;
    private byte[] devEui;
    private final String appId;
    private final String devId;
    private byte[] devAddr;
    private byte[] nwkSKey;
    private byte[] appSKey;
    private byte[] appKey;
    private int fCntUp;
    private int fCntDown;
    private boolean disableFCntCheck;
    private boolean uses32BitFCnt;
    private String activationConstraints;
    private final long lastSeen;

    private LorawanDevice(byte[] _appEui, byte[] _devEui, String _appId, String _devId, byte[] _devAddr, byte[] _nwkSKey, byte[] _appSKey, byte[] _appKey, int _fCntUp, int _fCntDown, boolean _disableFCntCheck, boolean _uses32BitFCnt, String _activationConstraints, long _lastSeen) {
        this.appEui = _appEui;
        this.devEui = _devEui;
        this.appId = _appId;
        this.devId = _devId;
        this.devAddr = _devAddr;
        this.nwkSKey = _nwkSKey;
        this.appSKey = _appSKey;
        this.appKey = _appKey;
        this.fCntUp = _fCntUp;
        this.fCntDown = _fCntDown;
        this.disableFCntCheck = _disableFCntCheck;
        this.uses32BitFCnt = _uses32BitFCnt;
        this.activationConstraints = _activationConstraints;
        this.lastSeen = _lastSeen;
    }

    public static LorawanDevice createOTAA(String _appId, String _devId, byte[] _appEui, byte[] _devEui, byte[] _appKey) {
        if (_appEui.length != 8) {
            throw new IllegalArgumentException("appEui should be 8 bytes long");
        }
        if (_devEui.length != 8) {
            throw new IllegalArgumentException("devEui should be 8 bytes long");
        }
        if (_appKey.length != 16) {
            throw new IllegalArgumentException("appKey should be 16 bytes long");
        }
        return new LorawanDevice(_appEui, _devEui, _appId, _devId, null, null, null, _appKey, 0, 0, false, true, "otaa", 0L);
    }

    public static LorawanDevice createABP(String _appId, String _devId, byte[] _appEui, byte[] _devEui, byte[] _devAddr, byte[] _nwkSKey, byte[] _appSKey, boolean _disableFCntCheck, boolean _uses32BitFCnt) {
        if (_appEui.length != 8) {
            throw new IllegalArgumentException("appEui should be 8 bytes long");
        }
        if (_devEui.length != 8) {
            throw new IllegalArgumentException("devEui should be 8 bytes long");
        }
        if (_devAddr.length != 4) {
            throw new IllegalArgumentException("devAddr should be 4 bytes long");
        }
        if (_nwkSKey.length != 16) {
            throw new IllegalArgumentException("nwkSKey should be 16 bytes long");
        }
        if (_appSKey.length != 16) {
            throw new IllegalArgumentException("appSKey should be 16 bytes long");
        }
        return new LorawanDevice(_appEui, _devEui, _appId, _devId, _devAddr, _nwkSKey, _appSKey, null, 0, 0, _disableFCntCheck, _uses32BitFCnt, "abp", 0L);
    }

    public static Observable<LorawanDevice> from(DeviceOuterClass.Device _proto) {
        return Observable.create(t -> {
            try {
                t.onNext((Object)new LorawanDevice(_proto.getAppEui().toByteArray(), _proto.getDevEui().toByteArray(), _proto.getAppId(), _proto.getDevId(), _proto.getDevAddr().toByteArray(), _proto.getNwkSKey().toByteArray(), _proto.getAppSKey().toByteArray(), _proto.getAppKey().toByteArray(), _proto.getFCntUp(), _proto.getFCntDown(), _proto.getDisableFCntCheck(), _proto.getUses32BitFCnt(), _proto.getActivationConstraints(), _proto.getLastSeen()));
                t.onCompleted();
            }
            catch (Exception ex) {
                t.onError((Throwable)ex);
            }
        });
    }

    public Observable<DeviceOuterClass.Device> toProto() {
        return Observable.create(t -> {
            try {
                t.onNext((Object)DeviceOuterClass.Device.newBuilder().setAppEui(ByteString.copyFrom((byte[])this.appEui)).setDevEui(ByteString.copyFrom((byte[])this.devEui)).setAppId(this.appId).setDevId(this.appId).setDevAddr(ByteString.copyFrom((byte[])this.devAddr)).setNwkSKey(ByteString.copyFrom((byte[])this.nwkSKey)).setAppSKey(ByteString.copyFrom((byte[])this.appSKey)).setAppKey(ByteString.copyFrom((byte[])this.appKey)).setFCntUp(this.fCntUp).setFCntDown(this.fCntDown).setDisableFCntCheck(this.disableFCntCheck).setUses32BitFCnt(this.uses32BitFCnt).setActivationConstraints(this.activationConstraints).setLastSeen(this.lastSeen).build());
                t.onCompleted();
            }
            catch (Exception ex) {
                t.onError((Throwable)ex);
            }
        });
    }

    public byte[] getAppEui() {
        return this.appEui;
    }

    public void setAppEui(byte[] _appEui) {
        if (_appEui.length != 8) {
            throw new IllegalArgumentException("appEui should be 8 bytes long");
        }
        this.appEui = _appEui;
    }

    public byte[] getDevEui() {
        return this.devEui;
    }

    public void setDevEui(byte[] _devEui) {
        if (_devEui.length != 8) {
            throw new IllegalArgumentException("devEui should be 8 bytes long");
        }
        this.devEui = _devEui;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDevId() {
        return this.devId;
    }

    public byte[] getDevAddr() {
        return this.devAddr;
    }

    public void setDevAddr(byte[] _devAddr) {
        if (_devAddr.length != 4) {
            throw new IllegalArgumentException("devAddr should be 4 bytes long");
        }
        this.devAddr = _devAddr;
    }

    public byte[] getNwkSKey() {
        return this.nwkSKey;
    }

    public void setNwkSKey(byte[] _nwkSKey) {
        if (_nwkSKey.length != 16) {
            throw new IllegalArgumentException("nwkSKey should be 16 bytes long");
        }
        this.nwkSKey = _nwkSKey;
    }

    public byte[] getAppSKey() {
        return this.appSKey;
    }

    public void setAppSKey(byte[] _appSKey) {
        if (_appSKey.length != 16) {
            throw new IllegalArgumentException("appSKey should be 16 bytes long");
        }
        this.appSKey = _appSKey;
    }

    public byte[] getAppKey() {
        return this.appKey;
    }

    public void setAppKey(byte[] _appKey) {
        if (_appKey.length != 16) {
            throw new IllegalArgumentException("appKey should be 16 bytes long");
        }
        this.appKey = _appKey;
    }

    public int getfCntUp() {
        return this.fCntUp;
    }

    public int getfCntDown() {
        return this.fCntDown;
    }

    public boolean isDisableFCntCheck() {
        return this.disableFCntCheck;
    }

    public void setDisableFCntCheck(boolean _disableFCntCheck) {
        this.disableFCntCheck = _disableFCntCheck;
    }

    public boolean isUses32BitFCnt() {
        return this.uses32BitFCnt;
    }

    public void setUses32BitFCnt(boolean _uses32BitFCnt) {
        this.uses32BitFCnt = _uses32BitFCnt;
    }

    public String getActivationConstraints() {
        return this.activationConstraints;
    }

    public void setActivationConstraints(String _activationConstraints) {
        this.activationConstraints = _activationConstraints;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void resetFCntUp() {
        this.fCntUp = 0;
    }

    public void resetFCntDown() {
        this.fCntDown = 0;
    }
}

