/*
 * Decompiled with CFR 0.152.
 */
package org.thethingsnetwork.management.async;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.ByteArrayInputStream;
import org.thethingsnetwork.account.async.auth.token.AsyncOAuth2Token;
import org.thethingsnetwork.management.async.AsyncHandler;
import org.thethingsnetwork.management.proto.DiscoveryGrpc;
import org.thethingsnetwork.management.proto.DiscoveryOuterClass;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class AsyncDiscovery {
    public static final String HOST = "discovery.thethingsnetwork.org";
    public static final int PORT = 1900;
    private final DiscoveryGrpc.DiscoveryFutureStub stub;

    private AsyncDiscovery(DiscoveryGrpc.DiscoveryFutureStub _stub) {
        this.stub = _stub;
    }

    public static Observable<AsyncDiscovery> from(String _host, int _port, Boolean useSecureConnection) {
        return Observable.create(t -> {
            try {
                ManagedChannel ch = ManagedChannelBuilder.forAddress((String)_host, (int)_port).usePlaintext(useSecureConnection == false).build();
                DiscoveryGrpc.DiscoveryFutureStub stub1 = DiscoveryGrpc.newFutureStub((Channel)ch);
                t.onNext((Object)new AsyncDiscovery(stub1));
                t.onCompleted();
            }
            catch (Exception ex) {
                t.onError((Throwable)ex);
            }
        });
    }

    public static Observable<AsyncDiscovery> getDefault() {
        return AsyncDiscovery.from(HOST, 1900, false);
    }

    public static Observable<AsyncDiscovery> getDefault(Boolean useSecureConnection) {
        return AsyncDiscovery.from(HOST, 1900, useSecureConnection);
    }

    public Observable<AsyncHandler> getHandler(AsyncOAuth2Token _creds, String _handlerId) {
        return Observable.from(this.stub.get(DiscoveryOuterClass.GetRequest.newBuilder().setId(_handlerId).setServiceName(Services.HANDLER.name().toLowerCase()).build()), (Scheduler)Schedulers.io()).flatMap(t -> this.from(_creds, (DiscoveryOuterClass.Announcement)t));
    }

    public Observable<AsyncHandler> getHandlers(AsyncOAuth2Token _creds) {
        return Observable.from(this.stub.getAll(DiscoveryOuterClass.GetServiceRequest.newBuilder().setServiceName(Services.HANDLER.name().toLowerCase()).build()), (Scheduler)Schedulers.io()).flatMap(t -> Observable.from(t.getServicesList())).flatMap(t -> this.from(_creds, (DiscoveryOuterClass.Announcement)t));
    }

    private Observable<AsyncHandler> from(AsyncOAuth2Token _creds, DiscoveryOuterClass.Announcement _announcement) {
        return Observable.from((Object[])_announcement.getNetAddress().split(",")).flatMap(tt -> Observable.create(t -> {
            try {
                t.onNext((Object)new Server((String)tt));
                t.onCompleted();
            }
            catch (Exception ex) {
                t.onError((Throwable)ex);
            }
        })).flatMap(t -> AsyncHandler.from(_creds, t.host, t.port, new ByteArrayInputStream(_announcement.getCertificate().getBytes())));
    }

    public static enum Services {
        HANDLER,
        BROKER,
        ROUTER;

    }

    private static class Server {
        public String host;
        public int port;

        public Server(String _s) {
            String[] tokens = _s.split(":");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Server address shout be formatted as: <host>:<port>");
            }
            this.host = tokens[0];
            this.port = Integer.parseInt(tokens[1]);
        }
    }
}

