/*
 * Decompiled with CFR 0.152.
 */
package org.thethingsnetwork.management.async;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.InputStream;
import org.thethingsnetwork.account.async.auth.token.AsyncOAuth2Token;
import org.thethingsnetwork.account.common.AbstractApplication;
import org.thethingsnetwork.management.HandlerApplication;
import org.thethingsnetwork.management.HandlerDevice;
import org.thethingsnetwork.management.proto.ApplicationManagerGrpc;
import org.thethingsnetwork.management.proto.HandlerOuterClass;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class AsyncHandler {
    private final ApplicationManagerGrpc.ApplicationManagerFutureStub stub;

    private AsyncHandler(ApplicationManagerGrpc.ApplicationManagerFutureStub _stub) {
        this.stub = _stub;
    }

    public static Observable<AsyncHandler> from(final AsyncOAuth2Token _credentials, String _host, int _port, InputStream _certificate) {
        return Observable.create(t -> {
            try {
                t.onNext((Object)new AsyncHandler(ApplicationManagerGrpc.newFutureStub((Channel)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)_host, (int)_port).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().trustManager(_certificate).build()).intercept(new ClientInterceptor[]{new ClientInterceptor(){

                    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                                headers.put(Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)_credentials.getRawToken());
                                super.start(responseListener, headers);
                            }
                        };
                    }
                }})).build())));
                t.onCompleted();
            }
            catch (Exception ex) {
                t.onError((Throwable)ex);
            }
        });
    }

    public Observable<HandlerApplication> registerApplication(AbstractApplication _application) {
        return Observable.from(this.stub.registerApplication(HandlerOuterClass.ApplicationIdentifier.newBuilder().setAppId(_application.getId()).build()), (Scheduler)Schedulers.io()).flatMap(ignore -> this.getApplication(_application.getId()));
    }

    public Observable<HandlerApplication> getApplication(String _applicationId) {
        return Observable.from(this.stub.getApplication(HandlerOuterClass.ApplicationIdentifier.newBuilder().setAppId(_applicationId).build()), (Scheduler)Schedulers.io()).flatMap(HandlerApplication::from);
    }

    public Observable<HandlerApplication> setApplication(HandlerApplication _application) {
        return _application.toProto().flatMap(t -> Observable.from(this.stub.setApplication((HandlerOuterClass.Application)t), (Scheduler)Schedulers.io())).map(ignore -> _application);
    }

    public Observable<HandlerApplication> deleteApplication(HandlerApplication _application) {
        return Observable.from(this.stub.deleteApplication(HandlerOuterClass.ApplicationIdentifier.newBuilder().setAppId(_application.getAppId()).build()), (Scheduler)Schedulers.io()).map(ignore -> _application);
    }

    public Observable<HandlerDevice> getDevices(HandlerApplication _application) {
        return Observable.from(this.stub.getDevicesForApplication(HandlerOuterClass.ApplicationIdentifier.newBuilder().setAppId(_application.getAppId()).build()), (Scheduler)Schedulers.io()).flatMap(t -> Observable.from(t.getDevicesList())).flatMap(t -> HandlerDevice.from(t));
    }

    public Observable<HandlerDevice> getDevice(HandlerApplication _application, String _deviceId) {
        return Observable.from(this.stub.getDevice(HandlerOuterClass.DeviceIdentifier.newBuilder().setAppId(_application.getAppId()).setDevId(_deviceId).build()), (Scheduler)Schedulers.io()).flatMap(t -> HandlerDevice.from(t));
    }

    public Observable<HandlerDevice> setDevice(HandlerDevice _device) {
        return _device.toProto().flatMap(tt -> Observable.from(this.stub.setDevice((HandlerOuterClass.Device)tt), (Scheduler)Schedulers.io()).map(t -> _device));
    }

    public Observable<HandlerDevice> deleteDevice(HandlerDevice _device) {
        return Observable.from(this.stub.deleteDevice(HandlerOuterClass.DeviceIdentifier.newBuilder().setAppId(_device.getAppId()).setDevId(_device.getDevId()).build()), (Scheduler)Schedulers.io()).map(t -> _device);
    }
}

