/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import springfox.documentation.service.Operation;

public class ApiDescription {
    private final String groupName;
    private final String path;
    private final String summary;
    private final String description;
    private final List<Operation> operations;
    private final Boolean hidden;

    public ApiDescription(String groupName, String path, String summary, String description, List<Operation> operations, Boolean hidden) {
        this.groupName = groupName;
        this.path = path;
        this.summary = summary;
        this.description = description;
        this.operations = operations;
        this.hidden = hidden;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public Optional<String> getGroupName() {
        return Optional.ofNullable(this.groupName);
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDescription that = (ApiDescription)o;
        return Objects.equals(this.groupName, that.groupName) && Objects.equals(this.path, that.path) && Objects.equals(this.summary, that.summary) && Objects.equals(this.description, that.description) && Objects.equals(this.operations, that.operations) && Objects.equals(this.hidden, that.hidden);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.path, this.summary, this.description, this.operations, this.hidden);
    }

    public String toString() {
        return new StringJoiner(", ", ApiDescription.class.getSimpleName() + "[", "]").add("groupName='" + this.groupName + "'").add("path='" + this.path + "'").add("summary='" + this.summary + "'").add("description='" + this.description + "'").add("operations=" + this.operations).add("hidden=" + this.hidden).toString();
    }
}

