/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@ThriftStruct(value="Array")
public final class ArrayField {
    @ThriftField(value=1)
    public boolean[] booleanArray;
    @ThriftField(value=2)
    public short[] shortArray;
    @ThriftField(value=3)
    public int[] intArray;
    @ThriftField(value=4)
    public long[] longArray;
    @ThriftField(value=5)
    public double[] doubleArray;
    @ThriftField(value=6)
    public byte[] byteArray;
    @ThriftField(value=11)
    public Map<Short, boolean[]> mapBooleanArray;
    @ThriftField(value=12)
    public Map<Short, short[]> mapShortArray;
    @ThriftField(value=13)
    public Map<Short, int[]> mapIntArray;
    @ThriftField(value=14)
    public Map<Short, long[]> mapLongArray;
    @ThriftField(value=15)
    public Map<Short, double[]> mapDoubleArray;

    public ArrayField() {
    }

    public ArrayField(boolean[] booleanArray, short[] shortArray, int[] intArray, long[] longArray, double[] doubleArray, byte[] byteArray) {
        this.booleanArray = booleanArray;
        this.shortArray = shortArray;
        this.intArray = intArray;
        this.longArray = longArray;
        this.doubleArray = doubleArray;
        this.byteArray = byteArray;
    }

    public ArrayField(boolean[] booleanArray, short[] shortArray, int[] intArray, long[] longArray, double[] doubleArray, byte[] byteArray, Map<Short, boolean[]> mapBooleanArray, Map<Short, short[]> mapShortArray, Map<Short, int[]> mapIntArray, Map<Short, long[]> mapLongArray, Map<Short, double[]> mapDoubleArray) {
        this.booleanArray = booleanArray;
        this.shortArray = shortArray;
        this.intArray = intArray;
        this.longArray = longArray;
        this.doubleArray = doubleArray;
        this.byteArray = byteArray;
        this.mapBooleanArray = mapBooleanArray;
        this.mapShortArray = mapShortArray;
        this.mapIntArray = mapIntArray;
        this.mapLongArray = mapLongArray;
        this.mapDoubleArray = mapDoubleArray;
    }

    public Map<Short, List<Boolean>> getMapBooleanList() {
        if (this.mapBooleanArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapBooleanArray, ArrayField.booleanArrayAsList());
    }

    public Map<Short, List<Short>> getMapShortList() {
        if (this.mapShortArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapShortArray, ArrayField.shortArrayAsList());
    }

    public Map<Short, List<Integer>> getMapIntegerList() {
        if (this.mapIntArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapIntArray, ArrayField.intArrayAsList());
    }

    public Map<Short, List<Long>> getMapLongList() {
        if (this.mapLongArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapLongArray, ArrayField.longArrayAsList());
    }

    public Map<Short, List<Double>> getMapDoubleList() {
        if (this.mapDoubleArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapDoubleArray, ArrayField.doubleArrayAsList());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.booleanArray, this.shortArray, this.intArray, this.longArray, this.doubleArray, this.byteArray, this.getMapBooleanList(), this.getMapShortList(), this.getMapIntegerList(), this.getMapLongList(), this.getMapDoubleList()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayField other = (ArrayField)obj;
        return Arrays.equals(this.booleanArray, other.booleanArray) && Arrays.equals(this.shortArray, other.shortArray) && Arrays.equals(this.intArray, other.intArray) && Arrays.equals(this.longArray, other.longArray) && Arrays.equals(this.doubleArray, other.doubleArray) && Arrays.equals(this.byteArray, other.byteArray) && Objects.equal(this.getMapBooleanList(), other.getMapBooleanList()) && Objects.equal(this.getMapShortList(), other.getMapShortList()) && Objects.equal(this.getMapIntegerList(), other.getMapIntegerList()) && Objects.equal(this.getMapLongList(), other.getMapLongList()) && Objects.equal(this.getMapDoubleList(), other.getMapDoubleList());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("booleanArray", (Object)Arrays.toString(this.booleanArray)).add("shortArray", (Object)Arrays.toString(this.shortArray)).add("intArray", (Object)Arrays.toString(this.intArray)).add("longArray", (Object)Arrays.toString(this.longArray)).add("doubleArray", (Object)Arrays.toString(this.doubleArray)).add("byteArray", (Object)Arrays.toString(this.byteArray)).add("mapBooleanArray", this.getMapBooleanList()).add("mapShortArray", this.getMapShortList()).add("mapIntArray", this.getMapIntegerList()).add("mapLongArray", this.getMapLongList()).add("mapDoubleArray", this.getMapDoubleList()).toString();
    }

    private static Function<boolean[], List<Boolean>> booleanArrayAsList() {
        return new Function<boolean[], List<Boolean>>(){

            @Nullable
            public List<Boolean> apply(@Nullable boolean[] input) {
                if (input == null) {
                    return null;
                }
                return Booleans.asList((boolean[])input);
            }
        };
    }

    private static Function<short[], List<Short>> shortArrayAsList() {
        return new Function<short[], List<Short>>(){

            @Nullable
            public List<Short> apply(@Nullable short[] input) {
                if (input == null) {
                    return null;
                }
                return Shorts.asList((short[])input);
            }
        };
    }

    private static Function<int[], List<Integer>> intArrayAsList() {
        return new Function<int[], List<Integer>>(){

            @Nullable
            public List<Integer> apply(@Nullable int[] input) {
                if (input == null) {
                    return null;
                }
                return Ints.asList((int[])input);
            }
        };
    }

    private static Function<long[], List<Long>> longArrayAsList() {
        return new Function<long[], List<Long>>(){

            @Nullable
            public List<Long> apply(@Nullable long[] input) {
                if (input == null) {
                    return null;
                }
                return Longs.asList((long[])input);
            }
        };
    }

    private static Function<double[], List<Double>> doubleArrayAsList() {
        return new Function<double[], List<Double>>(){

            @Nullable
            public List<Double> apply(@Nullable double[] input) {
                if (input == null) {
                    return null;
                }
                return Doubles.asList((double[])input);
            }
        };
    }
}

