/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import javax.annotation.concurrent.Immutable;

@ThriftStruct(value="Bonk", builder=Builder.class)
@Immutable
public final class BonkBuilder {
    private final String message;
    private final int type;

    public BonkBuilder(String message, int type) {
        this.message = message;
        this.type = type;
    }

    @ThriftField(value=1)
    public String getMessage() {
        return this.message;
    }

    @ThriftField(value=2)
    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BonkBuilder that = (BonkBuilder)o;
        if (this.type != that.type) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BonkBuilder");
        sb.append("{message='").append(this.message).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private String message;
        private int type;

        @ThriftField
        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        @ThriftField
        public Builder setType(int type) {
            this.type = type;
            return this;
        }

        @ThriftConstructor
        public BonkBuilder create() {
            return new BonkBuilder(this.message, this.type);
        }
    }
}

