/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.BonkField;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftType;
import org.apache.thrift.protocol.TProtocol;

public class BonkFieldThriftCodec
implements ThriftCodec<BonkField> {
    private final ThriftType type;

    public BonkFieldThriftCodec(ThriftType type) {
        this.type = type;
    }

    public ThriftType getType() {
        return this.type;
    }

    public BonkField read(TProtocol protocol) throws Exception {
        TProtocolReader reader = new TProtocolReader(protocol);
        String message = null;
        int type = 0;
        reader.readStructBegin();
        block4: while (reader.nextField()) {
            switch (reader.getFieldId()) {
                case 1: {
                    message = reader.readStringField();
                    continue block4;
                }
                case 2: {
                    type = reader.readI32Field();
                    continue block4;
                }
            }
            reader.skipFieldData();
        }
        reader.readStructEnd();
        BonkField bonkField = new BonkField();
        if (message != null) {
            bonkField.message = message;
        }
        bonkField.type = type;
        return bonkField;
    }

    public void write(BonkField value, TProtocol protocol) throws Exception {
        TProtocolWriter writer = new TProtocolWriter(protocol);
        writer.writeStructBegin("bonk");
        String message = value.message;
        if (message != null) {
            writer.writeStringField("message", (short)1, message);
        }
        writer.writeI32Field("type", (short)2, value.type);
        writer.writeStructEnd();
    }
}

