/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.Component;
import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;

@ThriftStruct(builder=Builder.class)
public interface DiscreteComponent
extends Component {
    @ThriftField(value=2)
    public String getUnits();

    public void setUnits(String var1);

    @ThriftField(value=3)
    public Double getValue();

    public void setValue(Double var1);

    public static class Capacitor
    extends BasicComponent {
        public Capacitor(String units, Double value) {
            super("Capacitor", units, value);
        }
    }

    public static class Resistor
    extends BasicComponent {
        public Resistor(String units, Double value) {
            super("Resistor", units, value);
        }
    }

    public static class BasicComponent
    implements DiscreteComponent {
        private final String name;
        private String units;
        private Double value;

        public BasicComponent(String name, String units, Double value) {
            this.name = name;
            this.units = units;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUnits() {
            return this.units;
        }

        @Override
        public void setUnits(String units) {
            this.units = units;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public void setValue(Double value) {
            this.value = value;
        }

        public int hashCode() {
            return Utils.hashCode(this);
        }

        public boolean equals(Object obj) {
            return Utils.areEqual(this, obj);
        }

        public String toString() {
            return Utils.toString(this);
        }
    }

    public static class Utils {
        private Utils() {
        }

        public static int hashCode(DiscreteComponent thi$) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (thi$.getName() == null ? 0 : thi$.getName().hashCode());
            result = 31 * result + (thi$.getUnits() == null ? 0 : thi$.getUnits().hashCode());
            result = 31 * result + (thi$.getValue() == null ? 0 : thi$.getValue().hashCode());
            return result;
        }

        public static boolean areEqual(DiscreteComponent thi$, Object obj) {
            if (thi$ == obj) {
                return true;
            }
            if (thi$ == null || obj == null) {
                return false;
            }
            if (!DiscreteComponent.class.isAssignableFrom(obj.getClass())) {
                return false;
            }
            DiscreteComponent other = (DiscreteComponent)obj;
            if (thi$.getName() == null ? other.getName() != null : !thi$.getName().equals(other.getName())) {
                return false;
            }
            if (thi$.getUnits() == null ? other.getUnits() != null : !thi$.getUnits().equals(other.getUnits())) {
                return false;
            }
            return !(thi$.getValue() == null ? other.getValue() != null : !thi$.getValue().equals(other.getValue()));
        }

        public static String toString(DiscreteComponent thi$) {
            if (thi$ == null) {
                throw new IllegalArgumentException("component cannot be null");
            }
            StringBuilder b = new StringBuilder().append("Discrete Component(").append(thi$.getClass().getName()).append(") [name=").append(thi$.getName()).append(", units=").append(thi$.getUnits()).append(", value=").append(thi$.getValue()).append("]");
            return b.toString();
        }
    }

    public static class Builder {
        private String name;
        private String units;
        private Double value;

        public String getName() {
            return this.name;
        }

        @ThriftField
        public void setName(String name) {
            this.name = name;
        }

        public String getUnits() {
            return this.units;
        }

        @ThriftField
        public void setUnits(String units) {
            this.units = units;
        }

        public Double getValue() {
            return this.value;
        }

        @ThriftField
        public void setValue(Double value) {
            this.value = value;
        }

        @ThriftConstructor
        public DiscreteComponent build() {
            if (this.getName() != null) {
                if (this.getName().equals("Resistor")) {
                    return new Resistor(this.getUnits(), this.getValue());
                }
                if (this.getName().equals("Capacitor")) {
                    return new Capacitor(this.getUnits(), this.getValue());
                }
            }
            return new BasicComponent(this.getName(), this.getUnits(), this.getValue());
        }
    }
}

