/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.Fruit;
import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftUnion;
import com.facebook.swift.codec.ThriftUnionId;
import com.google.common.base.Objects;

@ThriftUnion(builder=Builder.class)
public interface UnionInterface {
    @ThriftUnionId
    public short getType();

    @ThriftField(value=1)
    public String getStringValue();

    @ThriftField(value=2)
    public Long getLongValue();

    @ThriftField(value=3)
    public Fruit getFruitValue();

    public Object getValue();

    public static final class Builder {
        private Object value;
        private short type;

        @ThriftConstructor
        public UnionInterface build() {
            return Builder.createInstance(this.type, this.value);
        }

        @ThriftField
        public void setStringValue(String value) {
            this.type = 1;
            this.value = value;
        }

        @ThriftField
        public void setLongValue(Long value) {
            this.type = (short)2;
            this.value = value;
        }

        @ThriftField
        public void setFruitValue(Fruit value) {
            this.type = (short)3;
            this.value = value;
        }

        public static UnionInterface createInstance(String stringValue) {
            return Builder.createInstance((short)1, stringValue);
        }

        public static UnionInterface createInstance(Long longValue) {
            return Builder.createInstance((short)2, longValue);
        }

        public static UnionInterface createInstance(Fruit fruitValue) {
            return Builder.createInstance((short)3, (Object)fruitValue);
        }

        private static UnionInterface createInstance(final short _type, final Object _value) {
            return new UnionInterface(){

                @Override
                public short getType() {
                    return _type;
                }

                @Override
                public String getStringValue() {
                    if (_type != 1) {
                        throw new IllegalStateException("type is not a string");
                    }
                    return (String)_value;
                }

                @Override
                public Long getLongValue() {
                    if (_type != 2) {
                        throw new IllegalStateException("type is not a long");
                    }
                    return (Long)_value;
                }

                @Override
                public Fruit getFruitValue() {
                    if (_type != 3) {
                        throw new IllegalStateException("type is not a fruit");
                    }
                    return (Fruit)((Object)_value);
                }

                @Override
                public Object getValue() {
                    return _value;
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{_value, _type});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null || !UnionInterface.class.isAssignableFrom(obj.getClass())) {
                        return false;
                    }
                    UnionInterface that = (UnionInterface)obj;
                    return Objects.equal((Object)this.getType(), (Object)that.getType()) && Objects.equal((Object)this.getValue(), (Object)that.getValue());
                }

                public String toString() {
                    Objects.ToStringHelper helper = Objects.toStringHelper((Object)this);
                    if (_type == 1) {
                        helper.add("stringValue", (Object)((String)_value));
                    } else if (_type == 2) {
                        helper.add("longValue", (Object)((Long)_value));
                    } else if (_type == 3) {
                        helper.add("fruitValue", (Object)((Fruit)((Object)_value)));
                    }
                    return helper.toString();
                }
            };
        }
    }
}

