/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.BonkBean;
import com.facebook.swift.codec.BonkBuilder;
import com.facebook.swift.codec.BonkConstructor;
import com.facebook.swift.codec.BonkField;
import com.facebook.swift.codec.BonkMethod;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadataBuilder;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftStructMetadata {
    @Test
    public void testField() {
        ThriftStructMetadata metadata = this.testMetadataBuild(BonkField.class, 0, 0);
        this.verifyFieldInjection(metadata, 1, "message");
        this.verifyFieldExtraction(metadata, 1, "message");
        this.verifyFieldInjection(metadata, 2, "type");
        this.verifyFieldExtraction(metadata, 2, "type");
    }

    private void verifyFieldInjection(ThriftStructMetadata metadata, int id, String name) {
        ThriftInjection injection = (ThriftInjection)metadata.getField(id).getInjections().get(0);
        ((ObjectAssert)Assertions.assertThat((Object)injection).isNotNull()).isInstanceOf(ThriftFieldInjection.class);
        ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
        Assert.assertEquals((String)fieldInjection.getField().getName(), (String)name);
    }

    private void verifyFieldExtraction(ThriftStructMetadata metadata, int id, String name) {
        Assert.assertTrue((boolean)metadata.getField(id).getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)metadata.getField(id).getExtraction().get();
        Assertions.assertThat((Object)extraction).isInstanceOf(ThriftFieldExtractor.class);
        ThriftFieldExtractor fieldExtractor = (ThriftFieldExtractor)extraction;
        Assert.assertEquals((String)fieldExtractor.getField().getName(), (String)name);
    }

    @Test
    public void testBean() {
        ThriftStructMetadata metadata = this.testMetadataBuild(BonkBean.class, 0, 2);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 0);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    private void verifyParameterInjection(ThriftStructMetadata metadata, int id, String name, int parameterIndex) {
        ThriftInjection injection = (ThriftInjection)metadata.getField(id).getInjections().get(0);
        ((ObjectAssert)Assertions.assertThat((Object)injection).isNotNull()).isInstanceOf(ThriftParameterInjection.class);
        ThriftParameterInjection parameterInjection = (ThriftParameterInjection)injection;
        Assert.assertEquals((int)parameterInjection.getId(), (int)id);
        Assert.assertEquals((String)parameterInjection.getName(), (String)name);
        Assert.assertEquals((int)parameterInjection.getParameterIndex(), (int)parameterIndex);
    }

    private void verifyMethodExtraction(ThriftStructMetadata metadata, int id, String name, String methodName) {
        Assert.assertTrue((boolean)metadata.getField(id).getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)metadata.getField(id).getExtraction().get();
        Assertions.assertThat((Object)extraction).isInstanceOf(ThriftMethodExtractor.class);
        ThriftMethodExtractor methodExtractor = (ThriftMethodExtractor)extraction;
        Assert.assertEquals((String)methodExtractor.getMethod().getName(), (String)methodName);
        Assert.assertEquals((String)methodExtractor.getName(), (String)name);
    }

    @Test
    public void testConstructor() {
        ThriftStructMetadata metadata = this.testMetadataBuild(BonkConstructor.class, 2, 0);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 1);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    @Test
    public void testMethod() {
        ThriftStructMetadata metadata = this.testMetadataBuild(BonkMethod.class, 0, 1);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 1);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    @Test
    public void testBuilder() {
        ThriftStructMetadata metadata = this.testMetadataBuild(BonkBuilder.class, 0, 2);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 0);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    private ThriftStructMetadata testMetadataBuild(Class<?> structClass, int expectedConstructorParameters, int expectedMethodInjections) {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(catalog, structClass);
        Assert.assertNotNull((Object)builder);
        Assert.assertNotNull((Object)builder.getMetadataErrors());
        builder.getMetadataErrors().throwIfHasErrors();
        Assert.assertEquals((int)builder.getMetadataErrors().getWarnings().size(), (int)0);
        ThriftStructMetadata metadata = builder.build();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((Object)ThriftStructMetadata.MetadataType.STRUCT, (Object)metadata.getMetadataType());
        this.verifyField(metadata, 1, "message");
        this.verifyField(metadata, 2, "type");
        ThriftConstructorInjection constructorInjection = (ThriftConstructorInjection)metadata.getConstructorInjection().get();
        Assert.assertNotNull((Object)constructorInjection);
        Assert.assertEquals((int)constructorInjection.getParameters().size(), (int)expectedConstructorParameters);
        Assert.assertEquals((int)metadata.getMethodInjections().size(), (int)expectedMethodInjections);
        return metadata;
    }

    private <T> void verifyField(ThriftStructMetadata metadata, int id, String name) {
        ThriftFieldMetadata messageField = metadata.getField(id);
        Assert.assertNotNull((Object)messageField, (String)"messageField is null");
        Assert.assertEquals((int)messageField.getId(), (int)id);
        Assert.assertEquals((String)messageField.getName(), (String)name);
        Assert.assertFalse((boolean)messageField.isReadOnly());
        Assert.assertFalse((boolean)messageField.isWriteOnly());
        Assert.assertTrue((boolean)messageField.getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)messageField.getExtraction().get();
        Assert.assertEquals((int)extraction.getId(), (int)id);
        Assert.assertEquals((String)extraction.getName(), (String)name);
        Assert.assertNotNull((Object)messageField.getInjections());
        Assert.assertEquals((int)messageField.getInjections().size(), (int)1);
        ThriftInjection injection = (ThriftInjection)messageField.getInjections().get(0);
        Assert.assertEquals((int)injection.getId(), (int)id);
        Assert.assertEquals((String)injection.getName(), (String)name);
    }
}

