/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ComponentWithMultipleAnnotatedInterfaces;
import com.facebook.swift.codec.ComponentWithSetterAndNoBuilder;
import com.facebook.swift.codec.DiscreteComponent;
import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.metadata.MetadataErrorException;
import com.facebook.swift.codec.metadata.MetadataErrors;
import com.facebook.swift.codec.metadata.MetadataWarningException;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadataBuilder;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftStructMetadataBuilder {
    @Test
    public void testNoId() throws Exception {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), NoId.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("not have an id");
    }

    @Test
    public void testMultipleIds() throws Exception {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleIds.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("multiple ids");
    }

    @Test
    public void testMultipleNames() throws Exception {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleNames.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).isEmpty();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).hasSize(1);
        ((StringAssert)Assertions.assertThat((String)((MetadataWarningException)metadataErrors.getWarnings().get(0)).getMessage()).as("error message")).containsIgnoringCase("multiple names");
    }

    @Test
    public void testUnsupportedType() throws Exception {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), UnsupportedJavaType.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("not a supported Java type");
    }

    @Test
    public void testMultipleTypes() throws Exception {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleTypes.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("multiple types");
    }

    @Test
    public void testGenericBuilder() {
        Type structType = new TypeToken<GenericStruct<String>>(){}.getType();
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), structType);
        builder.build();
    }

    @Test(expectedExceptions={MetadataErrorException.class})
    public void testGenericBuilderForNonGenericStruct() {
        Type structType = new TypeToken<NonGenericStruct>(){}.getType();
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), structType);
        builder.build();
    }

    @Test
    public void testMulitpleRequiredness() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleRequiredness.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("multiple requiredness");
    }

    @Test
    public void testMergeableRequiredness() {
        ThriftStructMetadata metadata = new ThriftStructMetadataBuilder(new ThriftCatalog(), MergeableRequiredness.class).build();
        ((ObjectAssert)Assertions.assertThat((Object)metadata.getField(1).getRequiredness()).as("requiredness of field 'foo'")).isEqualTo((Object)ThriftField.Requiredness.OPTIONAL);
    }

    @Test
    public void testStructInterface() {
        ThriftStructMetadata metadata = new ThriftStructMetadataBuilder(new ThriftCatalog(), DiscreteComponent.class).build();
        ((CollectionAssert)Assertions.assertThat((Collection)metadata.getFields()).as("metadata for a valid struct interface")).hasSize(3);
    }

    @Test
    public void testInvalidStructWithMultipleAnnotatedInterfaces() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), ComponentWithMultipleAnnotatedInterfaces.class);
        MetadataErrors errors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)errors.getErrors()).as("metadata errors")).isNotEmpty();
        for (MetadataErrorException e : errors.getErrors()) {
            String msg = e.getMessage();
            if (!msg.contains("is annotated with @ThriftStruct, however there is also a @ThriftStruct annotation on")) continue;
            return;
        }
        Assert.fail((String)"should have had an error about multiple annotations.");
    }

    @Test
    public void testInvalidStructClassImplementsAnnotatedInterface() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), ComponentWithMultipleAnnotatedInterfaces.class);
        MetadataErrors errors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)errors.getErrors()).as("metadata errors")).isNotEmpty();
        for (MetadataErrorException e : errors.getErrors()) {
            String msg = e.getMessage();
            if (!msg.contains("is annotated with @ThriftStruct, however there is also a @ThriftStruct annotation on")) continue;
            return;
        }
        Assert.fail((String)"should have had an error about multiple annotations.");
    }

    @Test
    public void testInvalidInterfaceStructWithNoBuilder() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), ComponentWithSetterAndNoBuilder.class);
        MetadataErrors errors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)errors.getErrors()).as("metadata errors")).isNotEmpty();
        for (MetadataErrorException e : errors.getErrors()) {
            String msg = e.getMessage();
            if (!msg.contains("Interface structs must define a builder")) continue;
            return;
        }
        Assert.fail((String)"should have had an error saying that interface structs must define a builder.");
    }

    @Test
    public void testNonFinalStructsOk() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), NotFinalStruct.class);
        builder.build();
    }

    @ThriftStruct
    public static class NotFinalStruct {
    }

    @ThriftStruct
    public static final class MergeableRequiredness {
        @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
        public int getFoo() {
            return 0;
        }

        @ThriftField
        public void setFoo(int value) {
        }
    }

    @ThriftStruct
    public static final class MultipleRequiredness {
        @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
        public int getFoo() {
            return 0;
        }

        @ThriftField(value=1, requiredness=ThriftField.Requiredness.NONE)
        public void setFoo(int value) {
        }
    }

    @ThriftStruct(builder=GenericBuilder.class)
    public static class NonGenericStruct {
        private NonGenericStruct() {
        }

        public static class GenericBuilder<T> {
            @ThriftConstructor
            public NonGenericStruct build() {
                return new NonGenericStruct();
            }
        }
    }

    @ThriftStruct(builder=GenericBuilder.class)
    public static final class GenericStruct<T> {
        private T fieldValue;

        private GenericStruct(T fieldValue) {
            this.fieldValue = fieldValue;
        }

        @ThriftField(value=1)
        public T getFieldValue() {
            return this.fieldValue;
        }

        public static class GenericBuilder<T> {
            private T fieldValue;

            @ThriftField(value=1)
            public GenericBuilder<T> setFieldValue(T fieldValue) {
                this.fieldValue = fieldValue;
                return this;
            }

            @ThriftConstructor
            public GenericStruct<T> build() {
                return new GenericStruct(this.fieldValue);
            }
        }
    }

    @ThriftStruct
    public static final class MultipleTypes {
        @ThriftField(value=1)
        public int getFoo() {
            return 0;
        }

        @ThriftField
        public void setFoo(short value) {
        }
    }

    @ThriftStruct
    public static final class UnsupportedJavaType {
        @ThriftField(value=1)
        public Lock unsupportedJavaType;
    }

    @ThriftStruct
    public static final class MultipleNames {
        @ThriftField(value=1, name="foo")
        public String getFoo() {
            return null;
        }

        @ThriftField(value=1, name="bar")
        public void setFoo(String value) {
        }
    }

    @ThriftStruct
    public static final class MultipleIds {
        @ThriftField(name="foo", value=1)
        public void setField1(String value) {
        }

        @ThriftField(name="foo", value=2)
        public void setField2(String value) {
        }

        @ThriftField(name="foo")
        public String getField1() {
            return null;
        }

        @ThriftField(name="foo")
        public String getField2() {
            return null;
        }
    }

    @ThriftStruct
    public static final class NoId {
        @ThriftField
        public String getField1() {
            return null;
        }

        @ThriftField
        public void setField1(String value) {
        }
    }
}

