/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context;

import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.ITestContextExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestContext
implements ITestContext {
    private ITestContextExpression locale = null;
    private Map<String, ITestContextExpression> variables = new LinkedHashMap<String, ITestContextExpression>();
    private Map<String, ITestContextExpression[]> requestParameters = new LinkedHashMap<String, ITestContextExpression[]>();
    private Map<String, ITestContextExpression> requestAttributes = new LinkedHashMap<String, ITestContextExpression>();
    private Map<String, ITestContextExpression> sessionAttributes = new LinkedHashMap<String, ITestContextExpression>();
    private Map<String, ITestContextExpression> servletContextAttributes = new LinkedHashMap<String, ITestContextExpression>();

    @Override
    public ITestContextExpression getLocale() {
        return this.locale;
    }

    public void setLocale(ITestContextExpression locale) {
        this.locale = locale;
    }

    @Override
    public Map<String, ITestContextExpression> getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, ITestContextExpression[]> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public Map<String, ITestContextExpression> getRequestAttributes() {
        return this.requestAttributes;
    }

    @Override
    public Map<String, ITestContextExpression> getSessionAttributes() {
        return this.sessionAttributes;
    }

    @Override
    public Map<String, ITestContextExpression> getServletContextAttributes() {
        return this.servletContextAttributes;
    }

    @Override
    public ITestContext aggregate(ITestContext context) {
        TestContext newContext = new TestContext();
        newContext.setLocale(this.locale);
        newContext.getVariables().putAll(this.variables);
        newContext.getRequestParameters().putAll(this.requestParameters);
        newContext.getRequestAttributes().putAll(this.requestAttributes);
        newContext.getSessionAttributes().putAll(this.sessionAttributes);
        newContext.getServletContextAttributes().putAll(this.servletContextAttributes);
        if (context != null) {
            Map<String, ITestContextExpression> contextServletContextAttributes;
            Map<String, ITestContextExpression> contextSessionAttributes;
            Map<String, ITestContextExpression> contextRequestAttributes;
            Map<String, ITestContextExpression[]> contextRequestParameters;
            Map<String, ITestContextExpression> contextVariables;
            ITestContextExpression contextLocale = context.getLocale();
            if (contextLocale != null) {
                newContext.setLocale(context.getLocale());
            }
            if ((contextVariables = context.getVariables()) != null) {
                TestContext.mergeMaps(newContext.getVariables(), contextVariables);
            }
            if ((contextRequestParameters = context.getRequestParameters()) != null) {
                TestContext.mergeMaps(newContext.getRequestParameters(), contextRequestParameters);
            }
            if ((contextRequestAttributes = context.getRequestAttributes()) != null) {
                TestContext.mergeMaps(newContext.getRequestAttributes(), contextRequestAttributes);
            }
            if ((contextSessionAttributes = context.getSessionAttributes()) != null) {
                TestContext.mergeMaps(newContext.getSessionAttributes(), contextSessionAttributes);
            }
            if ((contextServletContextAttributes = context.getServletContextAttributes()) != null) {
                TestContext.mergeMaps(newContext.getServletContextAttributes(), contextServletContextAttributes);
            }
        }
        return newContext;
    }

    private static <T> void mergeMaps(Map<String, T> target, Map<String, T> newEntries) {
        for (Map.Entry<String, T> newEntry : newEntries.entrySet()) {
            String newEntryKey = newEntry.getKey();
            T newEntryValue = newEntry.getValue();
            target.remove(newEntryKey);
            target.put(newEntryKey, newEntryValue);
        }
    }
}

