/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.data;

import org.thymeleaf.testing.templateengine.standard.test.StandardTestValueType;
import org.thymeleaf.util.Validate;

public class StandardTestEvaluatedField {
    private static StandardTestEvaluatedField FOR_NO_VALUE = new StandardTestEvaluatedField(StandardTestValueType.NO_VALUE, null);
    private final StandardTestValueType valueType;
    private final Object value;

    public static StandardTestEvaluatedField forNoValue() {
        return FOR_NO_VALUE;
    }

    public static StandardTestEvaluatedField forDefaultValue(Object value) {
        return new StandardTestEvaluatedField(StandardTestValueType.DEFAULT, value);
    }

    public static StandardTestEvaluatedField forSpecifiedValue(Object value) {
        return new StandardTestEvaluatedField(StandardTestValueType.SPECIFIED, value);
    }

    private StandardTestEvaluatedField(StandardTestValueType valueType, Object value) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        this.valueType = valueType;
        this.value = value;
    }

    public boolean hasValue() {
        return !this.valueType.equals((Object)StandardTestValueType.NO_VALUE);
    }

    public boolean hasNotNullValue() {
        return this.hasValue() && this.value != null;
    }

    public boolean isDefault() {
        return this.hasValue() && this.valueType.equals((Object)StandardTestValueType.DEFAULT);
    }

    public boolean isSpecified() {
        return this.hasValue() && this.valueType.equals((Object)StandardTestValueType.SPECIFIED);
    }

    public StandardTestValueType getValueType() {
        return this.valueType;
    }

    public Object getValue() {
        return this.value;
    }
}

