/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import ognl.Ognl;
import org.apache.commons.lang3.LocaleUtils;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.testing.templateengine.context.IProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.ITestContextExpression;
import org.thymeleaf.testing.templateengine.context.web.ITestWebExchangeBuilder;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.IWebExchange;

public class WebProcessingContextBuilder
implements IProcessingContextBuilder {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String REQUEST_PARAMS_PREFIX = "param";
    private static final String REQUEST_ATTRS_PREFIX = "request";
    private static final String SESSION_ATTRS_PREFIX = "session";
    private static final String APPLICATION_ATTRS_PREFIX = "application";
    private final ITestWebExchangeBuilder testWebExchangeBuilder;

    public WebProcessingContextBuilder(ITestWebExchangeBuilder testWebExchangeBuilder) {
        Validate.notNull((Object)testWebExchangeBuilder, (String)"Test Web Exchange Builder cannot be null");
        this.testWebExchangeBuilder = testWebExchangeBuilder;
    }

    @Override
    public final IContext build(ITest test) {
        Object exprResult;
        if (test == null) {
            return null;
        }
        ITestContext testContext = test.getContext();
        Locale locale = DEFAULT_LOCALE;
        ITestContextExpression localeExpression = testContext.getLocale();
        if (localeExpression != null && (exprResult = localeExpression.evaluate(Collections.EMPTY_MAP, DEFAULT_LOCALE)) != null) {
            locale = LocaleUtils.toLocale((String)exprResult.toString());
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        LinkedHashMap<String, Object[]> requestParametersObj = new LinkedHashMap<String, Object[]>();
        variables.put(REQUEST_PARAMS_PREFIX, requestParametersObj);
        LinkedHashMap<String, Object> requestAttributes = new LinkedHashMap<String, Object>();
        variables.put(REQUEST_ATTRS_PREFIX, requestAttributes);
        LinkedHashMap<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();
        variables.put(SESSION_ATTRS_PREFIX, sessionAttributes);
        LinkedHashMap<String, Object> applicationAttributes = new LinkedHashMap<String, Object>();
        variables.put(APPLICATION_ATTRS_PREFIX, applicationAttributes);
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getVariables().entrySet()) {
            WebProcessingContextBuilder.resolve(entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getRequestParameters().entrySet()) {
            int n = entry.getKey().indexOf(46);
            String paramName = n == -1 ? entry.getKey() : entry.getKey().substring(0, n);
            String remainder = n == -1 ? "" : entry.getKey().substring(n);
            Object[] paramValues = new Object[((ITestContextExpression[])entry.getValue()).length];
            requestParametersObj.put(paramName, paramValues);
            int expressionsLen = ((ITestContextExpression[])entry.getValue()).length;
            for (int i = 0; i < expressionsLen; ++i) {
                WebProcessingContextBuilder.resolve("param." + paramName + "[" + i + "]" + remainder, ((ITestContextExpression[])entry.getValue())[i], variables, locale);
            }
        }
        LinkedHashMap<String, String[]> requestParameters = new LinkedHashMap<String, String[]>();
        for (Map.Entry entry : requestParametersObj.entrySet()) {
            Object[] value = (Object[])entry.getValue();
            String[] newValue = new String[value.length];
            for (int i = 0; i < value.length; ++i) {
                newValue[i] = value[i] == null ? null : value[i].toString();
            }
            requestParameters.put((String)entry.getKey(), newValue);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getRequestAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("request." + entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getSessionAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("session." + entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getApplicationAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("application." + entry.getKey(), entry.getValue(), variables, locale);
        }
        IWebExchange iWebExchange = this.testWebExchangeBuilder.buildExchange(test, requestAttributes, requestParameters, sessionAttributes, applicationAttributes, locale);
        variables.remove(REQUEST_PARAMS_PREFIX);
        variables.remove(REQUEST_ATTRS_PREFIX);
        variables.remove(SESSION_ATTRS_PREFIX);
        variables.remove(APPLICATION_ATTRS_PREFIX);
        this.doAdditionalVariableProcessing(test, iWebExchange, locale, variables);
        return this.doCreateWebContextInstance(test, iWebExchange, locale, variables);
    }

    protected void doAdditionalVariableProcessing(ITest test, IWebExchange webExchange, Locale locale, Map<String, Object> variables) {
    }

    protected IWebContext doCreateWebContextInstance(ITest test, IWebExchange webExchange, Locale locale, Map<String, Object> variables) {
        return new WebContext(webExchange, locale, variables);
    }

    private static void resolve(String expression, ITestContextExpression contextExpression, Map<String, Object> variables, Locale locale) {
        try {
            Object result = contextExpression.evaluate(variables, locale);
            Object parsedExpression = Ognl.parseExpression((String)expression);
            Ognl.setValue((Object)parsedExpression, variables, (Object)result);
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Exception while trying to evaluate expression \"" + expression + "\" on context for test \"" + TestExecutor.getThreadTestName() + "\"", t);
        }
    }
}

