/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators;

import java.io.File;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceResolver;
import org.thymeleaf.testing.templateengine.resource.LocalFileTestResource;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators.AbstractStandardTestFieldEvaluator;
import org.thymeleaf.testing.templateengine.util.ResourceUtils;

public abstract class AbstractTestResourceStandardTestFieldEvaluator
extends AbstractStandardTestFieldEvaluator {
    protected AbstractTestResourceStandardTestFieldEvaluator() {
        super(ITestResource.class);
    }

    @Override
    protected final StandardTestEvaluatedField getValue(String executionId, ITestResource resource, ITestResourceResolver testResourceResolver, String fieldName, String fieldQualifier, String fieldValue) {
        if (fieldValue == null || fieldValue.trim().equals("")) {
            return StandardTestEvaluatedField.forNoValue();
        }
        String value = fieldValue;
        if (AbstractTestResourceStandardTestFieldEvaluator.isValueInSameLineAsDirective(value)) {
            value = fieldValue.trim();
        }
        if (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.length() - 1);
            ITestResource newResource = testResourceResolver.resolve(value, resource);
            return StandardTestEvaluatedField.forSpecifiedValue(newResource);
        }
        File tempFile = ResourceUtils.createTempFile(executionId, this.getFileSuffix(), value, "UTF-8");
        LocalFileTestResource tempResource = new LocalFileTestResource(tempFile, "UTF-8", true);
        return StandardTestEvaluatedField.forSpecifiedValue(tempResource);
    }

    protected abstract String getFileSuffix();

    private static boolean isValueInSameLineAsDirective(String value) {
        int valueLen = value.length();
        for (int i = 0; i < valueLen; ++i) {
            char c = value.charAt(i);
            if (c != '\n' || valueLen <= i + 1) continue;
            return false;
        }
        return true;
    }
}

