/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.thymeleaf.util.Validate;
import org.unbescape.uri.UriEscape;

public final class JavaxServletMockUtils {
    public static final String DEFAULT_METHOD = "GET";
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_SERVER_NAME = "testing-server";
    public static final int DEFAULT_SERVER_PORT = 80;
    public static final String DEFAULT_CONTEXT_PATH = "/testing";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    public static final Function<String, String> DEFAULT_TRANSFORM_URL_FUNCTION = url -> url;

    private JavaxServletMockUtils() {
    }

    public static JavaxServletHttpServletRequestBuilder buildRequest(ServletContext servletContext, String path) {
        return new JavaxServletHttpServletRequestBuilder(servletContext, path);
    }

    public static JavaxServletHttpSessionBuilder buildSession(ServletContext servletContext) {
        return new JavaxServletHttpSessionBuilder(servletContext);
    }

    public static JavaxServletHttpServletResponseBuilder buildResponse() {
        return new JavaxServletHttpServletResponseBuilder();
    }

    public static JavaxServletServletContextBuilder buildServletContext() {
        return new JavaxServletServletContextBuilder();
    }

    private static HttpServletRequest createMockHttpServletRequest(ServletContext servletContext, String path, HttpSession session, Map<String, Object> attributeMap, Map<String, String[]> parameterMap, String method, String scheme, String serverName, int port, String contextPath, String contentType, String characterEncoding, Locale locale) {
        Validate.notNull((Object)servletContext, (String)"Servlet Context cannot be null");
        Validate.notEmpty((String)path, (String)"Path cannot be null or empty");
        Validate.notNull(attributeMap, (String)"Attribute Map cannot be null");
        Validate.notNull(parameterMap, (String)"Parameter Map cannot be null");
        Validate.notNull((Object)method, (String)"Method cannot be null");
        Validate.notNull((Object)scheme, (String)"Scheme cannot be null");
        Validate.notNull((Object)serverName, (String)"Server Name cannot be null");
        Validate.notNull((Object)contextPath, (String)"Context Path cannot be null");
        Validate.notNull((Object)contentType, (String)"Content Type cannot be null");
        Validate.notNull((Object)characterEncoding, (String)"Character Encoding cannot be null");
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        String protocol = "HTTP/1.1";
        String servletPath = "/" + UriEscape.escapeUriPath((String)(path.charAt(0) != '/' ? path : path.substring(1)));
        String requestURI = contextPath + servletPath;
        String requestURL = scheme + "://" + serverName + requestURI;
        String queryString = JavaxServletMockUtils.buildQueryString(parameterMap);
        int contentLength = -1;
        ObjectEnumeration headerNames = new ObjectEnumeration(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletContext()).thenReturn((Object)servletContext);
        Mockito.when((Object)request.getContentType()).thenReturn((Object)contentType);
        Mockito.when((Object)request.getCharacterEncoding()).thenReturn((Object)characterEncoding);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)request.getProtocol()).thenReturn((Object)"HTTP/1.1");
        Mockito.when((Object)request.getScheme()).thenReturn((Object)scheme);
        Mockito.when((Object)request.getServerName()).thenReturn((Object)serverName);
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)port);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)contextPath);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)servletPath);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestURI);
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(requestURL));
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)queryString);
        Mockito.when((Object)request.getLocale()).thenReturn((Object)locale);
        Mockito.when((Object)request.getLocales()).thenReturn(new ObjectEnumeration<Locale>(Arrays.asList(locale)));
        Mockito.when((Object)request.getContentLength()).thenReturn((Object)-1);
        Mockito.when((Object)request.getHeaderNames()).thenReturn(headerNames);
        Mockito.when((Object)request.getSession()).thenReturn((Object)session);
        Mockito.when((Object)request.getSession(ArgumentMatchers.anyBoolean())).thenReturn((Object)session);
        Mockito.when((Object)request.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributeMap));
        Mockito.when((Object)request.getAttribute(ArgumentMatchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributeMap));
        ((HttpServletRequest)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributeMap)).when((Object)request)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        ((HttpServletRequest)Mockito.doAnswer((Answer)new RemoveAttributeAnswer(attributeMap)).when((Object)request)).removeAttribute(ArgumentMatchers.anyString());
        Mockito.when((Object)request.getParameterNames()).thenAnswer((Answer)new GetVariableNamesAnswer(parameterMap));
        Mockito.when((Object)request.getParameterValues(ArgumentMatchers.anyString())).thenAnswer((Answer)new GetParameterValuesAnswer(parameterMap));
        Mockito.when((Object)request.getParameterMap()).thenReturn(parameterMap);
        Mockito.when((Object)request.getParameter(ArgumentMatchers.anyString())).thenAnswer((Answer)new GetParameterAnswer(parameterMap));
        return request;
    }

    private static HttpSession createMockHttpSession(ServletContext servletContext, Map<String, Object> attributeMap) {
        Validate.notNull((Object)servletContext, (String)"Servlet Context canot be null");
        Validate.notNull(attributeMap, (String)"Attribute Map cannot be null");
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)session.getServletContext()).thenReturn((Object)servletContext);
        Mockito.when((Object)session.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributeMap));
        Mockito.when((Object)session.getAttribute(ArgumentMatchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributeMap));
        ((HttpSession)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributeMap)).when((Object)session)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        ((HttpSession)Mockito.doAnswer((Answer)new RemoveAttributeAnswer(attributeMap)).when((Object)session)).removeAttribute(ArgumentMatchers.anyString());
        return session;
    }

    private static HttpServletResponse createMockHttpServletResponse(Function<String, String> transformUrlFunction) {
        Validate.notNull(transformUrlFunction, (String)"transformUrl Function cannot be null");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.encodeURL(ArgumentMatchers.anyString())).thenAnswer((Answer)new EncodeUrlAnswer(transformUrlFunction));
        return response;
    }

    private static ServletContext createMockServletContext(String contextPath, Map<String, Object> attributeMap) {
        Validate.notNull((Object)contextPath, (String)"Context Path cannot be null");
        Validate.notNull(attributeMap, (String)"Attribute Map cannot be null");
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributeMap));
        Mockito.when((Object)servletContext.getAttribute(ArgumentMatchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributeMap));
        ((ServletContext)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributeMap)).when((Object)servletContext)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        ((ServletContext)Mockito.doAnswer((Answer)new RemoveAttributeAnswer(attributeMap)).when((Object)servletContext)).removeAttribute(ArgumentMatchers.anyString());
        Mockito.when((Object)servletContext.getContextPath()).thenReturn((Object)contextPath);
        Mockito.when((Object)servletContext.getInitParameterNames()).thenReturn(new ObjectEnumeration(null));
        Mockito.when((Object)servletContext.getInitParameter(ArgumentMatchers.anyString())).thenReturn(null);
        return servletContext;
    }

    private static String testNameToServletPath(String testName) {
        String normalizedName = StringUtils.stripAccents((String)testName);
        if (normalizedName.contains("/")) {
            normalizedName = normalizedName.substring(normalizedName.lastIndexOf(47));
        }
        if (normalizedName.contains("\\")) {
            normalizedName = normalizedName.substring(normalizedName.lastIndexOf(92));
        }
        if (normalizedName.endsWith(".thtest")) {
            normalizedName = normalizedName.substring(0, normalizedName.length() - 7);
        }
        StringBuilder strBuilder = new StringBuilder();
        int nameLen = normalizedName.length();
        for (int i = 0; i < nameLen; ++i) {
            char c = normalizedName.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            strBuilder.append(c);
        }
        return UriEscape.escapeUriPath((String)strBuilder.toString());
    }

    private static String buildQueryString(Map<String, String[]> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        StringBuilder strBuilder = new StringBuilder();
        for (Map.Entry<String, String[]> parameterEntry : parameters.entrySet()) {
            String parameterName = parameterEntry.getKey();
            String[] parameterValues = parameterEntry.getValue();
            if (parameterValues == null || parameterValues.length == 0) {
                if (strBuilder.length() > 0) {
                    strBuilder.append('&');
                }
                strBuilder.append(parameterName);
                continue;
            }
            for (String parameterValue : parameterValues) {
                if (strBuilder.length() > 0) {
                    strBuilder.append('&');
                }
                strBuilder.append(parameterName);
                if (parameterValue == null) continue;
                strBuilder.append("=");
                try {
                    strBuilder.append(URLEncoder.encode(parameterValue, DEFAULT_CHARACTER_ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return strBuilder.toString();
    }

    public static final class JavaxServletHttpServletRequestBuilder {
        private final ServletContext servletContext;
        private final String path;
        private HttpSession session = null;
        private Map<String, Object> attributeMap = null;
        private Map<String, String[]> parameterMap = null;
        private String method = "GET";
        private String scheme = "http";
        private String serverName = "testing-server";
        private int port = 80;
        private String contextPath = "/testing";
        private String contentType = "text/html";
        private String characterEncoding = "UTF-8";
        private Locale locale = DEFAULT_LOCALE;

        private JavaxServletHttpServletRequestBuilder(ServletContext servletContext, String path) {
            this.servletContext = servletContext;
            this.path = path;
        }

        public JavaxServletHttpServletRequestBuilder session(HttpSession session) {
            this.session = session;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder attributeMap(Map<String, Object> attributeMap) {
            this.attributeMap = attributeMap;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder parameterMap(Map<String, String[]> parameterMap) {
            this.parameterMap = parameterMap;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder port(int port) {
            this.port = port;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder characterEncoding(String characterEncoding) {
            this.characterEncoding = characterEncoding;
            return this;
        }

        public JavaxServletHttpServletRequestBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public HttpServletRequest build() {
            return JavaxServletMockUtils.createMockHttpServletRequest(this.servletContext, this.path, this.session, this.attributeMap != null ? this.attributeMap : new HashMap(), this.parameterMap != null ? this.parameterMap : new HashMap(), this.method, this.scheme, this.serverName, this.port, this.contextPath, this.contentType, this.characterEncoding, this.locale);
        }
    }

    public static final class JavaxServletHttpSessionBuilder {
        private final ServletContext servletContext;
        private Map<String, Object> attributeMap = null;

        private JavaxServletHttpSessionBuilder(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public JavaxServletHttpSessionBuilder attributeMap(Map<String, Object> attributeMap) {
            this.attributeMap = attributeMap;
            return this;
        }

        public HttpSession build() {
            return JavaxServletMockUtils.createMockHttpSession(this.servletContext, this.attributeMap != null ? this.attributeMap : new HashMap());
        }
    }

    public static final class JavaxServletHttpServletResponseBuilder {
        private Function<String, String> transformUrlFunction = DEFAULT_TRANSFORM_URL_FUNCTION;

        private JavaxServletHttpServletResponseBuilder() {
        }

        public JavaxServletHttpServletResponseBuilder transformUrlFunction(Function<String, String> transformUrlFunction) {
            this.transformUrlFunction = transformUrlFunction;
            return this;
        }

        public HttpServletResponse build() {
            return JavaxServletMockUtils.createMockHttpServletResponse(this.transformUrlFunction);
        }
    }

    public static final class JavaxServletServletContextBuilder {
        private String contextPath = "/testing";
        private Map<String, Object> attributeMap = null;

        private JavaxServletServletContextBuilder() {
        }

        public JavaxServletServletContextBuilder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public JavaxServletServletContextBuilder attributeMap(Map<String, Object> attributeMap) {
            this.attributeMap = attributeMap;
            return this;
        }

        public ServletContext build() {
            return JavaxServletMockUtils.createMockServletContext(this.contextPath, this.attributeMap != null ? this.attributeMap : new HashMap());
        }
    }

    private static class ObjectEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        public ObjectEnumeration(Collection<T> values) {
            this.iterator = values != null ? new ArrayList<T>(values).iterator() : Collections.emptyList().iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }

    private static class GetVariableNamesAnswer
    implements Answer<Enumeration<?>> {
        private final Map<String, ?> values;

        public GetVariableNamesAnswer(Map<String, ?> values) {
            this.values = values;
        }

        public Enumeration<?> answer(InvocationOnMock invocation) throws Throwable {
            return new ObjectEnumeration<String>(this.values.keySet());
        }
    }

    private static class GetAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public GetAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            return this.values.get(attributeName);
        }
    }

    private static class SetAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public SetAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            Object attributeValue = invocation.getArguments()[1];
            if (attributeValue == null) {
                this.values.remove(attributeName);
            } else {
                this.values.put(attributeName, attributeValue);
            }
            return null;
        }
    }

    private static class RemoveAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public RemoveAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            this.values.remove(attributeName);
            return null;
        }
    }

    private static class GetParameterValuesAnswer
    implements Answer<String[]> {
        private final Map<String, String[]> values;

        public GetParameterValuesAnswer(Map<String, String[]> values) {
            this.values = values;
        }

        public String[] answer(InvocationOnMock invocation) throws Throwable {
            String parameterName = (String)invocation.getArguments()[0];
            return this.values.get(parameterName);
        }
    }

    private static class GetParameterAnswer
    implements Answer<String> {
        private final Map<String, String[]> values;

        public GetParameterAnswer(Map<String, String[]> values) {
            this.values = values;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            String parameterName = (String)invocation.getArguments()[0];
            String[] parameterValues = this.values.get(parameterName);
            return parameterValues != null ? parameterValues[0] : null;
        }
    }

    private static class EncodeUrlAnswer
    implements Answer<String> {
        private final Function<String, String> transformUrlFunction;

        public EncodeUrlAnswer(Function<String, String> transformUrlFunction) {
            Validate.notNull(transformUrlFunction, (String)"transformUrl Function cannot be null");
            this.transformUrlFunction = transformUrlFunction;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            return this.transformUrlFunction.apply((String)invocation.getArguments()[0]);
        }
    }
}

