/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.annotation.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.annotation.AnnotationExcuteManager;
import org.tinygroup.annotation.config.AnnotationClassMatchers;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class AnnotationFileProcessor
extends AbstractFileProcessor {
    private static final String ANNOTATION_EXT_FILENAME = ".annotation.xml";
    private AnnotationExcuteManager manager;

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(ANNOTATION_EXT_FILENAME);
    }

    public AnnotationExcuteManager getManager() {
        return this.manager;
    }

    public void setManager(AnnotationExcuteManager manager) {
        this.manager = manager;
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"annotation");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664\u6ce8\u89e3\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            AnnotationClassMatchers annotationClassMatchers = (AnnotationClassMatchers)this.caches.get(fileObject.getAbsolutePath());
            if (annotationClassMatchers != null) {
                this.manager.removeAnnotationClassMatchers(annotationClassMatchers);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664\u6ce8\u89e3\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u6ce8\u89e3\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            AnnotationClassMatchers oldMatchers = (AnnotationClassMatchers)this.caches.get(fileObject.getAbsolutePath());
            if (oldMatchers != null) {
                this.manager.removeAnnotationClassMatchers(oldMatchers);
            }
            InputStream inputStream = fileObject.getInputStream();
            AnnotationClassMatchers matchers = (AnnotationClassMatchers)stream.fromXML(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u5173\u95ed\u6587\u4ef6\u6d41\u65f6\u51fa\u9519,\u6587\u4ef6\u8def\u5f84:{}", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            this.manager.addAnnotationClassMatchers(matchers);
            this.caches.put(fileObject.getAbsolutePath(), matchers);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7d\u6ce8\u89e3\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

