/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.annotation.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTypeMatcher {
    private List<Pattern> classPatterns = new ArrayList<Pattern>();
    private Pattern annotationPattern;

    public AnnotationTypeMatcher(List<String> classNames, String annotationType) {
        if (classNames != null) {
            for (String name : classNames) {
                Pattern pattern = Pattern.compile(name);
                this.classPatterns.add(pattern);
            }
        }
        if (!StringUtil.isBlank((String)annotationType)) {
            this.annotationPattern = Pattern.compile(annotationType);
        }
    }

    public boolean isMatch(String classFullPath) {
        for (Pattern pattern : this.classPatterns) {
            Matcher matcher = pattern.matcher(classFullPath);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnnotationTypeMatch(Annotation annotation) {
        Matcher matcher = this.annotationPattern.matcher(annotation.annotationType().getName());
        return matcher.matches();
    }
}

