/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.annotation.AnnotationClassAction;
import org.tinygroup.annotation.AnnotationExecuteManager;
import org.tinygroup.annotation.AnnotationMethodAction;
import org.tinygroup.annotation.AnnotationPropertyAction;
import org.tinygroup.annotation.config.AnnotationClassMatcher;
import org.tinygroup.annotation.config.AnnotationClassMatchers;
import org.tinygroup.annotation.config.AnnotationMethodMatcher;
import org.tinygroup.annotation.config.AnnotationPropertyMatcher;
import org.tinygroup.annotation.config.ProcessorBean;
import org.tinygroup.annotation.fileresolver.AnnotationFileProcessor;
import org.tinygroup.annotation.impl.AnnotationClassMap;
import org.tinygroup.annotation.impl.AnnotationMatcherDto;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.Configuration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.loader.LoaderManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;

public class AnnotationExecuteManagerImpl
implements AnnotationExecuteManager,
Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationFileProcessor.class);
    private static final int CLASS_SUFFIX_LENGTH = 6;
    private static final String ANNOTATION_NODE_PATH = "/application/annotation-configuration";
    private static final String MAP_VALUE = "value";
    private static final String MAP_ID = "id";
    protected XmlNode applicationConfig;
    protected XmlNode componentConfig;
    private List<AnnotationClassMatcher> classMatchers = new ArrayList<AnnotationClassMatcher>();

    @Override
    public void addAnnotationClassMatchers(AnnotationClassMatchers annotationClassMatchers) {
        annotationClassMatchers.initAnnotationClassMatchers();
        this.classMatchers.addAll(annotationClassMatchers.getAnnotationClassMatcherList());
    }

    @Override
    public void removeAnnotationClassMatchers(AnnotationClassMatchers annotationClassMatchers) {
        this.classMatchers.removeAll(annotationClassMatchers.getAnnotationClassMatcherList());
    }

    @Override
    public void processClassFileObject(FileObject fileObject) {
        for (AnnotationClassMatcher classMatcher : this.classMatchers) {
            String className;
            if (!classMatcher.isClassMatch(className = this.getFullClassName(fileObject))) continue;
            LOGGER.logMessage(LogLevel.DEBUG, "\u627e\u5230\u5339\u914d\u7c7b\u540d\u6b63\u5219[{0}]\u7684\u7c7b:[{1}]", new Object[]{classMatcher.getClassName(), className});
            try {
                Class clazz = LoaderManager.getClass((String)className);
                this.processClassProcessor(clazz, classMatcher);
                this.processPropertyProcessor(clazz, classMatcher.getAnnotationPropertyMatchers());
                this.processMethodProcessor(clazz, classMatcher.getAnnotationMethodMatchers());
            }
            catch (ClassNotFoundException e) {
                LOGGER.errorMessage("\u52a0\u8f7d\u5668\u52a0\u8f7d\u7684\u7c7b[{0}]\u4e0d\u5b58\u5728", (Throwable)e, new Object[]{className});
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u52a0\u8f7d\u5668\u52a0\u8f7d\u7684\u7c7b[{0}]\u65f6\u51fa\u73b0\u9519\u8bef\uff1a[{1}]", (Throwable)e, new Object[]{className, e.getMessage()});
            }
        }
    }

    private <T> void processClassProcessor(Class<T> clazz, AnnotationClassMatcher classMatcher) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = clazz.getDeclaredAnnotations()) {
            if (!classMatcher.isAnnotationTypeMatch(annotation)) continue;
            LOGGER.logMessage(LogLevel.DEBUG, "\u7c7b\u4e0a\u5b58\u5728\u7b26\u5408\u6b63\u5219[{0}]\u7684\u6ce8\u89e3", new Object[]{classMatcher.getAnnotationType()});
            this.processClassBean(clazz, annotation, new AnnotationMatcherDto(classMatcher));
        }
    }

    private <T> void processMethodProcessor(Class<T> clazz, List<AnnotationMethodMatcher> annotationMethodMatchers) {
        Method[] declaredMethods = clazz.getDeclaredMethods();
        for (AnnotationMethodMatcher annotationMethodMatcher : annotationMethodMatchers) {
            for (Method method : declaredMethods) {
                Annotation[] annotations;
                if (!annotationMethodMatcher.isMethodMatch(method.getName())) continue;
                LOGGER.logMessage(LogLevel.DEBUG, "\u627e\u5230\u5339\u914d\u65b9\u6cd5\u540d\u6b63\u5219[{0}]\u7684\u65b9\u6cd5:[{1}]", new Object[]{annotationMethodMatcher.getMethodName(), method.getName()});
                for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                    if (!annotationMethodMatcher.isAnnotationTypeMatch(annotation)) continue;
                    LOGGER.logMessage(LogLevel.DEBUG, "\u65b9\u6cd5\u4e0a\u5b58\u5728\u7b26\u5408\u6b63\u5219[{0}]\u7684\u6ce8\u89e3", new Object[]{annotationMethodMatcher.getAnnotationType()});
                    this.processMethodBean(clazz, annotation, new AnnotationMatcherDto(annotationMethodMatcher, method));
                }
            }
        }
    }

    private <T> void processPropertyProcessor(Class<T> clazz, List<AnnotationPropertyMatcher> annotationPropertyMatchers) {
        Field[] declaredFields = clazz.getDeclaredFields();
        for (AnnotationPropertyMatcher annotationPropertyMatcher : annotationPropertyMatchers) {
            for (Field field : declaredFields) {
                Annotation[] annotations;
                if (!annotationPropertyMatcher.isPropertyMatch(field.getName())) continue;
                LOGGER.logMessage(LogLevel.DEBUG, "\u627e\u5230\u5339\u914d\u5c5e\u6027\u540d\u6b63\u5219[{0}]\u7684\u5c5e\u6027:[{1}]", new Object[]{annotationPropertyMatcher.getPropertyName(), field.getName()});
                for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
                    if (!annotationPropertyMatcher.isAnnotationTypeMatch(annotation)) continue;
                    LOGGER.logMessage(LogLevel.DEBUG, "\u5c5e\u6027\u4e0a\u5b58\u5728\u7b26\u5408\u6b63\u5219[{0}]\u7684\u6ce8\u89e3", new Object[]{annotationPropertyMatcher.getAnnotationType()});
                    this.processPropertyBean(clazz, annotation, new AnnotationMatcherDto(annotationPropertyMatcher, field));
                }
            }
        }
    }

    private String getFullClassName(FileObject fileObject) {
        String fileName = this.getFilePath(fileObject);
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName.replaceAll("/", ".");
    }

    private String getFilePath(FileObject fileObject) {
        String path = fileObject.getPath();
        return path.substring(0, path.length() - 6);
    }

    private <T> void processClassBean(Class<T> clazz, Annotation annotation, AnnotationMatcherDto annotationMatcherDto) {
        List<ProcessorBean> processorBeans = annotationMatcherDto.getAnnotationClassMatcher().getProcessorBeans();
        for (ProcessorBean processorBean : processorBeans) {
            AnnotationClassAction classAction;
            if (!processorBean.getEnable().booleanValue() || (classAction = (AnnotationClassAction)this.newInstance(processorBean)) == null) continue;
            classAction.process(clazz, annotation);
        }
    }

    private <T> void processMethodBean(Class<T> clazz, Annotation annotation, AnnotationMatcherDto annotationMatcherDto) {
        List<ProcessorBean> processorBeans = annotationMatcherDto.getAnnotationMethodMatcher().getProcessorBeans();
        for (ProcessorBean processorBean : processorBeans) {
            AnnotationMethodAction methodAction;
            if (!processorBean.getEnable().booleanValue() || (methodAction = (AnnotationMethodAction)this.newInstance(processorBean)) == null) continue;
            methodAction.process(clazz, annotationMatcherDto.getMethod(), annotation);
        }
    }

    private Object newInstance(ProcessorBean processorBean) {
        String beanName = processorBean.getName();
        if (!StringUtil.isBlank((String)beanName)) {
            return BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
        }
        try {
            Object instance = Class.forName(processorBean.getType()).newInstance();
            return instance;
        }
        catch (Exception e) {
            LOGGER.errorMessage("type:[{0}]\u5b9e\u4f8b\u5316\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[]{processorBean.getType()});
            return null;
        }
    }

    private <T> void processPropertyBean(Class<T> clazz, Annotation annotation, AnnotationMatcherDto annotationMatcherDto) {
        List<ProcessorBean> processorBeans = annotationMatcherDto.getAnnotationPropertyMatcher().getProcessorBeans();
        for (ProcessorBean processorBean : processorBeans) {
            AnnotationPropertyAction propertyAction;
            if (!processorBean.getEnable().booleanValue() || (propertyAction = (AnnotationPropertyAction)this.newInstance(processorBean)) == null) continue;
            propertyAction.process(clazz, annotationMatcherDto.getField(), annotation);
        }
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
        List combineNodes = ConfigurationUtil.combineSubList((XmlNode)applicationConfig, (XmlNode)componentConfig);
        for (XmlNode xmlNode : combineNodes) {
            AnnotationClassMap.putAnnotationMap(xmlNode.getAttribute(MAP_ID), xmlNode.getAttribute(MAP_VALUE));
        }
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public String getApplicationNodePath() {
        return ANNOTATION_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return "/annotation.config.xml";
    }
}

