/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.annotation.impl;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.fileresolver.FileResolver;

public class JavaPathManage {
    private static final String FILE_RESOLVER = "fileResolver";
    private static final String BACK_SLASH = "\\";
    private static final String POINT = ".";
    private static final String EXCLAMATION_MARK = "!";
    private static final String JAR_SUFFIX = ".jar";
    private static final String EXCLAMATION_AND_SLASH_MARK = "!/";
    private static final String SLASH_MARK = "/";
    private List<String> javaPaths = new ArrayList<String>();
    private FileResolver fileResolver;

    public void init() {
        this.fileResolver = (FileResolver)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(FILE_RESOLVER);
        ArrayList paths = new ArrayList();
        paths.addAll(this.fileResolver.getScanningPaths());
        for (String path : paths) {
            if (path.indexOf(JAR_SUFFIX) != -1) continue;
            if (!path.endsWith(SLASH_MARK)) {
                path = path.concat(SLASH_MARK);
            }
            this.javaPaths.add(path.replace(BACK_SLASH, SLASH_MARK));
        }
    }

    public String obtainClassName(String fileName) {
        String className = null;
        int jarIndex = fileName.indexOf(EXCLAMATION_MARK);
        if (jarIndex != -1) {
            className = fileName.substring(jarIndex + EXCLAMATION_AND_SLASH_MARK.length(), fileName.length());
        } else {
            for (String class_path : this.javaPaths) {
                int index = fileName.indexOf(class_path);
                if (index == -1) continue;
                className = fileName.substring(index + class_path.length(), fileName.length());
                break;
            }
        }
        if (className == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u7684className,\u6587\u4ef6\u540d:" + fileName);
        }
        return className.replace(SLASH_MARK, POINT);
    }
}

