/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.annotation.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.annotation.config.AnnotationMethodMatcher;
import org.tinygroup.annotation.config.AnnotationPropertyMatcher;
import org.tinygroup.annotation.config.AnnotationTypeMatcher;
import org.tinygroup.annotation.config.ProcessorBean;
import org.tinygroup.annotation.impl.AnnotationClassMap;

@XStreamAlias(value="annotation-class-matcher")
public class AnnotationClassMatcher {
    @XStreamAlias(value="annotation-id")
    @XStreamAsAttribute
    private String annotationId;
    @XStreamAlias(value="class-name")
    @XStreamAsAttribute
    private String className;
    @XStreamAlias(value="annotation-type")
    @XStreamAsAttribute
    private String annotationType;
    @XStreamAlias(value="processor-beans")
    @XStreamAsAttribute
    private List<ProcessorBean> processorBeans;
    @XStreamAlias(value="annotation-property-matchers")
    @XStreamAsAttribute
    private List<AnnotationPropertyMatcher> annotationPropertyMatchers;
    @XStreamAlias(value="annotation-method-matchers")
    @XStreamAsAttribute
    private List<AnnotationMethodMatcher> annotationMethodMatchers;
    private AnnotationTypeMatcher annotationTypeMatcher;

    public void initAnnotationTypeMatcher() {
        List<String> classNames = null;
        if (this.annotationId != null) {
            classNames = AnnotationClassMap.getClassNamesById(this.annotationId);
        }
        if (classNames == null) {
            classNames = new ArrayList<String>();
            classNames.add(this.className);
        }
        if (this.annotationTypeMatcher == null) {
            this.annotationTypeMatcher = new AnnotationTypeMatcher(classNames, this.annotationType);
        }
        if (this.annotationPropertyMatchers != null) {
            for (AnnotationPropertyMatcher annotationPropertyMatcher : this.annotationPropertyMatchers) {
                annotationPropertyMatcher.initAnnotationTypeMatcher();
            }
        }
        if (this.annotationMethodMatchers != null) {
            for (AnnotationMethodMatcher annotationMethodMatcher : this.annotationMethodMatchers) {
                annotationMethodMatcher.initAnnotationTypeMatcher();
            }
        }
    }

    public boolean isClassMatch(String classFullPath) {
        return this.annotationTypeMatcher.isMatch(classFullPath);
    }

    public boolean isAnnotationTypeMatch(Annotation annotation) {
        return this.annotationTypeMatcher.isAnnotationTypeMatch(annotation);
    }

    public String getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(String annotationId) {
        this.annotationId = annotationId;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public List<ProcessorBean> getProcessorBeans() {
        if (this.processorBeans == null) {
            this.processorBeans = new ArrayList<ProcessorBean>();
        }
        return this.processorBeans;
    }

    public void setProcessorBeans(List<ProcessorBean> processorBeans) {
        this.processorBeans = processorBeans;
    }

    public List<AnnotationPropertyMatcher> getAnnotationPropertyMatchers() {
        if (this.annotationPropertyMatchers == null) {
            this.annotationPropertyMatchers = new ArrayList<AnnotationPropertyMatcher>();
        }
        return this.annotationPropertyMatchers;
    }

    public void setAnnotationPropertyMatchers(List<AnnotationPropertyMatcher> annotationPropertyMatchers) {
        this.annotationPropertyMatchers = annotationPropertyMatchers;
    }

    public List<AnnotationMethodMatcher> getAnnotationMethodMatchers() {
        if (this.annotationMethodMatchers == null) {
            this.annotationMethodMatchers = new ArrayList<AnnotationMethodMatcher>();
        }
        return this.annotationMethodMatchers;
    }

    public void setAnnotationMethodMatchers(List<AnnotationMethodMatcher> annotationMethodMatchers) {
        this.annotationMethodMatchers = annotationMethodMatchers;
    }
}

