/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.annotation.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.annotation.config.AnnotationTypeMatcher;
import org.tinygroup.annotation.config.ProcessorBean;

@XStreamAlias(value="annotation-property-matcher")
public class AnnotationPropertyMatcher {
    @XStreamAlias(value="property-name")
    @XStreamAsAttribute
    private String propertyName;
    @XStreamAlias(value="annotation-type")
    @XStreamAsAttribute
    private String annotationType;
    @XStreamAlias(value="processor-beans")
    @XStreamAsAttribute
    private List<ProcessorBean> processorBeans;
    private AnnotationTypeMatcher annotationTypeMatcher;

    public void initAnnotationTypeMatcher() {
        if (this.annotationTypeMatcher == null) {
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.add(this.propertyName);
            this.annotationTypeMatcher = new AnnotationTypeMatcher(propertyNames, this.annotationType);
        }
    }

    public boolean isPropertyMatch(String classFullPath) {
        return this.annotationTypeMatcher.isMatch(classFullPath);
    }

    public boolean isAnnotationTypeMatch(Annotation annotation) {
        return this.annotationTypeMatcher.isAnnotationTypeMatch(annotation);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public List<ProcessorBean> getProcessorBeans() {
        if (this.processorBeans == null) {
            this.processorBeans = new ArrayList<ProcessorBean>();
        }
        return this.processorBeans;
    }

    public void setProcessorBeans(List<ProcessorBean> processorBeans) {
        this.processorBeans = processorBeans;
    }
}

