/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.channel;

import junit.framework.TestCase;
import org.tinygroup.channel.ChannelSample;
import org.tinygroup.channel.EventFilter;
import org.tinygroup.channel.EventListener;
import org.tinygroup.channel.EventProcessor1;
import org.tinygroup.channel.EventProcessor2;
import org.tinygroup.channel.util.ChannelTestUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.event.Event;
import org.tinygroup.event.ServiceRequest;

public class ChannelSampleTest
extends TestCase {
    ChannelSample channelSample;

    protected void setUp() throws Exception {
        super.setUp();
        this.channelSample = new ChannelSample();
        this.channelSample.setCepCore(ChannelTestUtil.getCep());
        EventFilter eventFilter = new EventFilter(){

            public Event filter(Event event) {
                Event e = event;
                event.getServiceRequest().setServiceId(event.getServiceRequest().getServiceId().toLowerCase());
                return e;
            }
        };
        this.channelSample.addSendEventFilter(eventFilter);
        this.channelSample.addReceiveEventFilter(eventFilter);
        EventListener eventListener = new EventListener(){

            public void process(Event event) {
                System.out.println(String.format("Log:%s", event.getServiceRequest().getServiceId()));
            }
        };
        this.channelSample.addSendEventListener(eventListener);
        this.channelSample.addReceiveEventListener(eventListener);
        ChannelTestUtil.registerEventProcessor(new EventProcessor1());
        ChannelTestUtil.registerEventProcessor(new EventProcessor2());
    }

    public void testSendEvent() {
        Event event = this.getEvent();
        this.channelSample.sendEvent(event);
    }

    private Event getEvent() {
        Event event = new Event();
        event.setEventId("123");
        ServiceRequest serviceRequest = new ServiceRequest();
        event.setServiceRequest(serviceRequest);
        serviceRequest.setServiceId("aabbcc");
        serviceRequest.setContext((Context)new ContextImpl());
        return event;
    }

    public void testReceiveEvent() {
        Event event = this.getEvent();
        this.channelSample.process(event);
    }
}

