/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.channel.impl;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.channel.ChannelInterface;
import org.tinygroup.channel.EventFilter;
import org.tinygroup.channel.EventListener;
import org.tinygroup.event.Event;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChannel
implements ChannelInterface {
    private List<EventFilter> sendEventFilters = new ArrayList<EventFilter>();
    private List<EventFilter> receiveEventFilters = new ArrayList<EventFilter>();
    private List<EventListener> sendEventListeners = new ArrayList<EventListener>();
    private List<EventListener> receiveEventListeners = new ArrayList<EventListener>();
    private String id;
    private CEPCore cepCore;
    private Logger logger = LoggerFactory.getLogger(AbstractChannel.class);

    public CEPCore getCepCore() {
        return this.cepCore;
    }

    public void setCepCore(CEPCore cepCore) {
        this.cepCore = cepCore;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<EventFilter> getSendEventFilters() {
        return this.sendEventFilters;
    }

    public List<EventFilter> getReceiveEventFilters() {
        return this.receiveEventFilters;
    }

    public List<EventListener> getSendEventListeners() {
        return this.sendEventListeners;
    }

    public List<EventListener> getReceiveEventListeners() {
        return this.receiveEventListeners;
    }

    @Override
    public void addSendEventListener(EventListener eventListener) {
        this.sendEventListeners.add(eventListener);
    }

    @Override
    public void addReceiveEventListener(EventListener eventListener) {
        this.receiveEventListeners.add(eventListener);
    }

    @Override
    public void addSendEventFilter(EventFilter eventFilter) {
        this.sendEventFilters.add(eventFilter);
    }

    @Override
    public void addReceiveEventFilter(EventFilter eventFilter) {
        this.receiveEventFilters.add(eventFilter);
    }

    @Override
    public void sendEvent(Event event) {
        this.processEventListener(event, this.sendEventListeners);
        try {
            this.cepCore.process(this.filterEvent(event, this.sendEventFilters));
        }
        catch (RuntimeException e) {
            this.error(e);
        }
    }

    private Event filterEvent(Event event, List<EventFilter> eventFilters) {
        Event e = event;
        for (EventFilter filter : eventFilters) {
            e = filter.filter(e);
        }
        return e;
    }

    public void process(Event event) {
        this.processEventListener(event, this.receiveEventListeners);
        try {
            this.receive(this.filterEvent(event, this.receiveEventFilters));
        }
        catch (RuntimeException e) {
            this.error(e);
        }
    }

    private void error(RuntimeException e) {
        this.logger.errorMessage("\u901a\u9053\u5904\u7406\u9519\u8bef", (Throwable)e);
        throw e;
    }

    protected abstract void receive(Event var1);

    private void processEventListener(Event event, List<EventListener> eventListeners) {
        if (eventListeners.size() > 0) {
            for (EventListener eventListener : eventListeners) {
                try {
                    eventListener.process(event);
                }
                catch (RuntimeException e) {
                    this.error(e);
                }
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

