/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.channel.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.tinygroup.channel.impl.AbstractChannel;
import org.tinygroup.event.Event;
import org.tinygroup.queue.PriorityQueue;
import org.tinygroup.queue.impl.PriorityQueueImpl;

public abstract class AbstractQueueChannel
extends AbstractChannel {
    private PriorityQueue<Event> sendQueue = null;
    private PriorityQueue<Event> receiveQueue = null;
    ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private volatile Boolean stopSign = true;
    private EventProcessTask eventProcessTask;

    public void setQueueInfo(int sendQueueSize, int receiveQueueSize) {
        if (sendQueueSize > 0) {
            this.sendQueue = new PriorityQueueImpl(sendQueueSize);
        }
        if (receiveQueueSize > 0) {
            this.receiveQueue = new PriorityQueueImpl(receiveQueueSize);
        }
    }

    protected abstract void sendReal(Event var1);

    protected abstract void receiveReal(Event var1);

    protected void send(Event event) {
        this.sendQueue.offer((Object)event);
        this.eventProcessTask.notify();
    }

    protected void receive(Event event) {
        this.receiveQueue.offer((Object)event);
        this.eventProcessTask.notify();
    }

    public void start() {
        this.stopSign = false;
        this.eventProcessTask = new EventProcessTask();
        this.executorService.execute(this.eventProcessTask);
    }

    public void stop() {
        this.stopSign = true;
        this.executorService.shutdown();
    }

    class SendEventTask
    extends Thread {
        private Event event;

        public SendEventTask(Event event) {
            this.event = event;
        }

        public void run() {
            AbstractQueueChannel.this.sendReal(this.event);
        }
    }

    class ReceiveProcessTask
    extends Thread {
        private Event event;

        public ReceiveProcessTask(Event event) {
            this.event = event;
        }

        public void run() {
            AbstractQueueChannel.this.receiveReal(this.event);
        }
    }

    class EventProcessTask
    extends Thread {
        EventProcessTask() {
        }

        public void run() {
            while (!AbstractQueueChannel.this.stopSign.booleanValue()) {
                this.processSend();
                this.processReceive();
                if (!AbstractQueueChannel.this.sendQueue.isEmpty() || !AbstractQueueChannel.this.receiveQueue.isEmpty()) continue;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processReceive() {
            PriorityQueue priorityQueue = AbstractQueueChannel.this.sendQueue;
            synchronized (priorityQueue) {
                AbstractQueueChannel.this.executorService.execute(new SendEventTask((Event)AbstractQueueChannel.this.sendQueue.peek()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSend() {
            PriorityQueue priorityQueue = AbstractQueueChannel.this.receiveQueue;
            synchronized (priorityQueue) {
                AbstractQueueChannel.this.executorService.execute(new ReceiveProcessTask((Event)AbstractQueueChannel.this.receiveQueue.peek()));
            }
        }
    }
}

