/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.channel;

import junit.framework.TestCase;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.cepcore.EventProcessor;
import org.tinygroup.channel.CEPCoreForTest;
import org.tinygroup.channel.ChannelInterface;
import org.tinygroup.channel.ChannelSample;
import org.tinygroup.channel.EventFilter;
import org.tinygroup.channel.EventListener;
import org.tinygroup.channel.EventProcessor1;
import org.tinygroup.channel.EventProcessor2;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.event.Event;
import org.tinygroup.event.ServiceRequest;

public class ChannelWithCEPCoreTest
extends TestCase {
    ChannelInterface channelSample;

    protected void setUp() throws Exception {
        super.setUp();
        CEPCoreForTest cepCore = new CEPCoreForTest();
        this.channelSample = new ChannelSample();
        this.channelSample.setCepCore((CEPCore)cepCore);
        EventFilter eventFilter = new EventFilter(){

            public Event filter(Event event) {
                Event e = event;
                return e;
            }
        };
        this.channelSample.addSendEventFilter(eventFilter);
        this.channelSample.addReceiveEventFilter(eventFilter);
        EventListener eventListener = new EventListener(){

            public void process(Event event) {
                System.out.println(String.format("Log:%s", event.getServiceRequest().getServiceId()));
            }
        };
        this.channelSample.addSendEventListener(eventListener);
        this.channelSample.addReceiveEventListener(eventListener);
        cepCore.registerEventProcessor((EventProcessor)this.channelSample);
        cepCore.registerEventProcessor(new EventProcessor1());
        cepCore.registerEventProcessor(new EventProcessor2());
    }

    public void testSendEvent() {
        Event event = this.getEvent("aabbcc", "", "", "");
        this.channelSample.sendEvent(event);
        ChannelWithCEPCoreTest.assertEquals((Object)"aa", (Object)event.getServiceRequest().getContext().get("result"));
        event = this.getEvent("111111", "aabbcc1", "a", "a");
        this.channelSample.sendEvent(event);
        ChannelWithCEPCoreTest.assertEquals((Object)"bb", (Object)event.getServiceRequest().getContext().get("result"));
    }

    public void testSendEvent1() {
        Event event = this.getEvent("111111", "111111", "a", "a");
        this.channelSample.sendEvent(event);
        ChannelWithCEPCoreTest.assertEquals((Object)"bb", (Object)event.getServiceRequest().getContext().get("result"));
    }

    private Event getEvent(String id, String name, String artifactId, String groupId) {
        Event event = new Event();
        event.setEventId("123");
        ServiceRequest serviceRequest = new ServiceRequest();
        event.setServiceRequest(serviceRequest);
        serviceRequest.setServiceId(id);
        serviceRequest.setContext((Context)new ContextImpl());
        return event;
    }
}

