/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.command.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.command.CommandSystem;
import org.tinygroup.command.config.Commands;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class CommandFileProcessor
extends AbstractFileProcessor {
    private static final String COMMAND_EXT_FILENAME = ".commands.xml";

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(COMMAND_EXT_FILENAME);
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)CommandSystem.COMMANDS_XSTREAM);
        for (FileObject fileObject : this.fileObjects) {
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dCommands\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            try {
                Commands commands = (Commands)stream.fromXML(fileObject.getInputStream());
                CommandSystem.getInstance(commands.getPackageName(), commands, System.out);
            }
            catch (Exception e) {
                logger.errorMessage("\u52a0\u8f7dCommands\u6587\u4ef6[{0}]\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dCommands\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

