/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.command.test;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.tinygroup.command.CommandSystem;
import org.tinygroup.command.config.Commands;

public class ConsoleCommander
extends Thread {
    CommandSystem commandSystem;

    public ConsoleCommander() {
        XStream stream = new XStream();
        stream.autodetectAnnotations(true);
        stream.alias("commands", Commands.class);
        File file = new File("src/main/resources/sys.commands.xml");
        Commands commands = (Commands)stream.fromXML(file);
        this.commandSystem = CommandSystem.getInstance((String)"cmd", (Commands)commands, (OutputStream)System.out);
    }

    public void run() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String str = "";
        while (str != null) {
            try {
                System.out.print(">");
                str = in.readLine();
                if (str.equals("exit") || str.equals("quit")) {
                    this.commandSystem.println("Byebye");
                    return;
                }
                this.commandSystem.execute(str);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        new ConsoleCommander().start();
    }
}

