/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.beanutil;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.beanutils.PropertyUtils;
import org.tinygroup.commons.namediscover.LocalVariableTableParameterNameDiscoverer;
import org.tinygroup.commons.namediscover.ParameterNameDiscoverer;
import org.tinygroup.commons.tools.ClassUtil;

public class BeanUtil {
    private static ParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    public static String[] getMethodParameterName(Class<?> clazz, Method method) {
        return discoverer.getParameterNames(method);
    }

    public static String[] getMethodParameterName(Method method) {
        return discoverer.getParameterNames(method);
    }

    public static String[] getMethodParameterName(Constructor ctor) {
        return discoverer.getParameterNames(ctor);
    }

    public static Object deepCopy(Object orig) throws Exception {
        PropertyDescriptor[] origDescriptors;
        Object dest = orig.getClass().newInstance();
        for (PropertyDescriptor propertyDescriptor : origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig)) {
            String name = propertyDescriptor.getName();
            if (!PropertyUtils.isReadable((Object)orig, (String)name) || !PropertyUtils.isWriteable(dest, (String)name)) continue;
            Object[] value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
            Object valueDest = null;
            if (value != null && BeanUtil.canDeepCopyObject(value)) {
                if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    Collection newColl = BeanUtil.createApproximateCollection(value);
                    Iterator it = coll.iterator();
                    while (it.hasNext()) {
                        newColl.add(BeanUtil.deepCopy(it.next()));
                    }
                    valueDest = newColl;
                } else if (value.getClass().isArray()) {
                    Object[] values = value;
                    Object[] newValues = new Object[values.length];
                    for (int i = 0; i < newValues.length; ++i) {
                        newValues[i] = BeanUtil.deepCopy(values[i]);
                    }
                    valueDest = newValues;
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    Map newMap = BeanUtil.createApproximateMap(map);
                    for (Object key : map.keySet()) {
                        newMap.put(key, BeanUtil.deepCopy(map.get(key)));
                    }
                    valueDest = newMap;
                } else {
                    valueDest = BeanUtil.deepCopy(value);
                }
            } else {
                valueDest = value;
            }
            PropertyUtils.setSimpleProperty(dest, (String)name, (Object)valueDest);
        }
        return dest;
    }

    private static boolean canDeepCopyObject(Object value) {
        if (ClassUtil.getPrimitiveType(value.getClass()) != null) {
            return false;
        }
        return !(value instanceof String);
    }

    public static Collection createApproximateCollection(Object collection) {
        if (collection instanceof LinkedList) {
            return new LinkedList();
        }
        if (collection instanceof List) {
            return new ArrayList();
        }
        if (collection instanceof SortedSet) {
            return new TreeSet(((SortedSet)collection).comparator());
        }
        return new LinkedHashSet();
    }

    public static Map createApproximateMap(Object map) {
        if (map instanceof SortedMap) {
            return new TreeMap(((SortedMap)map).comparator());
        }
        return new LinkedHashMap();
    }
}

