/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.collection;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ClassUtil;

public abstract class Conventions {
    private static final String PLURAL_SUFFIX = "List";
    private static final Set<Class<?>> ignoredInterfaces = new HashSet();

    public static String getVariableName(Object value) {
        Class<?> valueClass;
        Assert.assertNotNull(value, "Value must not be null", new Object[0]);
        boolean pluralize = false;
        if (value.getClass().isArray()) {
            valueClass = value.getClass().getComponentType();
            pluralize = true;
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object valueToCheck = Conventions.peekAhead(collection);
            valueClass = Conventions.getClassForValue(valueToCheck);
            pluralize = true;
        } else {
            valueClass = Conventions.getClassForValue(value);
        }
        String name = ClassUtil.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String getQualifiedAttributeName(Class<?> enclosingClass, String attributeName) {
        Assert.assertNotNull(enclosingClass, "'enclosingClass' must not be null", new Object[0]);
        Assert.assertNotNull(attributeName, "'attributeName' must not be null", new Object[0]);
        return enclosingClass.getName() + "." + attributeName;
    }

    private static Class<?> getClassForValue(Object value) {
        Class<?> valueClass = value.getClass();
        if (Proxy.isProxyClass(valueClass)) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = valueClass.getInterfaces()) {
                if (ignoredInterfaces.contains(ifc)) continue;
                return ifc;
            }
        } else if (valueClass.getName().lastIndexOf(36) != -1 && valueClass.getDeclaringClass() == null) {
            valueClass = valueClass.getSuperclass();
        }
        return valueClass;
    }

    private static String pluralize(String name) {
        return name + PLURAL_SUFFIX;
    }

    private static Object peekAhead(Collection<?> collection) {
        Iterator<?> it = collection.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        Object value = it.next();
        if (value == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return value;
    }

    static {
        ignoredInterfaces.add(Serializable.class);
        ignoredInterfaces.add(Externalizable.class);
        ignoredInterfaces.add(Cloneable.class);
        ignoredInterfaces.add(Comparable.class);
    }
}

