/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import org.tinygroup.commons.exceptions.UnexpectedFailureException;
import org.tinygroup.commons.exceptions.UnreachableCodeException;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;

public final class Assert {
    public static <T> T assertNotNull(T object) {
        return Assert.assertNotNull(object, null, null, (Object[])null);
    }

    public static <T> T assertNotNull(T object, String message, Object ... args) {
        return Assert.assertNotNull(object, null, message, args);
    }

    public static <T> T assertNotNull(T object, ExceptionType exceptionType, String message, Object ... args) {
        if (object == null) {
            if (exceptionType == null) {
                exceptionType = ExceptionType.ILLEGAL_ARGUMENT;
            }
            throw exceptionType.newInstance(Assert.getMessage(message, args, "[Assertion failed] - the argument is required; it must not be null"));
        }
        return object;
    }

    public static void notEmpty(Object[] array, String message) {
        if (ObjectUtil.isEmptyObject(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T assertNull(T object) {
        return Assert.assertNull(object, null, null, (Object[])null);
    }

    public static <T> T assertNull(T object, String message, Object ... args) {
        return Assert.assertNull(object, null, message, args);
    }

    public static <T> T assertNull(T object, ExceptionType exceptionType, String message, Object ... args) {
        if (object != null) {
            if (exceptionType == null) {
                exceptionType = ExceptionType.ILLEGAL_ARGUMENT;
            }
            throw exceptionType.newInstance(Assert.getMessage(message, args, "[Assertion failed] - the object argument must be null"));
        }
        return object;
    }

    public static void assertTrue(boolean expression) {
        Assert.assertTrue(expression, null, null, (Object[])null);
    }

    public static void assertTrue(boolean expression, String message, Object ... args) {
        Assert.assertTrue(expression, null, message, args);
    }

    public static void assertTrue(boolean expression, ExceptionType exceptionType, String message, Object ... args) {
        if (!expression) {
            if (exceptionType == null) {
                exceptionType = ExceptionType.ILLEGAL_ARGUMENT;
            }
            throw exceptionType.newInstance(Assert.getMessage(message, args, "[Assertion failed] - the expression must be true"));
        }
    }

    public static <T> T unreachableCode() {
        Assert.unreachableCode(null, null);
        return null;
    }

    public static <T> T unreachableCode(String message, Object ... args) {
        throw ExceptionType.UNREACHABLE_CODE.newInstance(Assert.getMessage(message, args, "[Assertion failed] - the code is expected as unreachable"));
    }

    public static <T> T unexpectedException(Throwable e) {
        Assert.unexpectedException(e, null, null);
        return null;
    }

    public static <T> T unexpectedException(Throwable e, String message, Object ... args) {
        RuntimeException exception = ExceptionType.UNEXPECTED_FAILURE.newInstance(Assert.getMessage(message, args, "[Assertion failed] - unexpected exception is thrown"));
        exception.initCause(e);
        throw exception;
    }

    public static <T> T fail() {
        Assert.fail(null, null);
        return null;
    }

    public static <T> T fail(String message, Object ... args) {
        throw ExceptionType.UNEXPECTED_FAILURE.newInstance(Assert.getMessage(message, args, "[Assertion failed] - unexpected failure"));
    }

    public static <T> T unsupportedOperation() {
        Assert.unsupportedOperation(null, null);
        return null;
    }

    public static <T> T unsupportedOperation(String message, Object ... args) {
        throw ExceptionType.UNSUPPORTED_OPERATION.newInstance(Assert.getMessage(message, args, "[Assertion failed] - unsupported operation or unimplemented function"));
    }

    public static void hasLength(String text, String message) {
        if (StringUtil.isBlank(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text) {
        Assert.hasLength(text, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static void hasText(String text, String message) {
        if (StringUtil.isBlank(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text) {
        Assert.hasText(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
    }

    public static void isAssignable(Class superType, Class subType) {
        Assert.isAssignable(superType, subType, "");
    }

    public static void isAssignable(Class superType, Class subType, String message) {
        Assert.assertNotNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(message + subType + " is not assignable to " + superType);
        }
    }

    private static String getMessage(String message, Object[] args, String defaultMessage) {
        if (message == null) {
            message = defaultMessage;
        }
        if (args == null || args.length == 0) {
            return message;
        }
        return String.format(message, args);
    }

    public static enum ExceptionType {
        ILLEGAL_ARGUMENT{

            @Override
            RuntimeException newInstance(String message) {
                return new IllegalArgumentException(message);
            }
        }
        ,
        ILLEGAL_STATE{

            @Override
            RuntimeException newInstance(String message) {
                return new IllegalStateException(message);
            }
        }
        ,
        NULL_POINT{

            @Override
            RuntimeException newInstance(String message) {
                return new NullPointerException(message);
            }
        }
        ,
        UNREACHABLE_CODE{

            @Override
            RuntimeException newInstance(String message) {
                return new UnreachableCodeException(message);
            }
        }
        ,
        UNEXPECTED_FAILURE{

            @Override
            RuntimeException newInstance(String message) {
                return new UnexpectedFailureException(message);
            }
        }
        ,
        UNSUPPORTED_OPERATION{

            @Override
            RuntimeException newInstance(String message) {
                return new UnsupportedOperationException(message);
            }
        };


        abstract RuntimeException newInstance(String var1);
    }
}

