/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.IndentableStringBuilder;
import org.tinygroup.commons.tools.ObjectUtil;

public class ToStringBuilder {
    private static final String NULL_STR = "<null>";
    private static final int ARRAY_ITEMS_PER_LINE = 10;
    private final IndentableStringBuilder out;
    private final Formatter formatter;
    private boolean printDescription;

    public ToStringBuilder() {
        this(-1);
    }

    public ToStringBuilder(int indent) {
        this.out = new IndentableStringBuilder(indent);
        this.formatter = new Formatter(this.out);
    }

    public void clear() {
        this.out.clear();
        this.printDescription = false;
    }

    public IndentableStringBuilder out() {
        return this.out;
    }

    public boolean isPrintDescription() {
        return this.printDescription;
    }

    public ToStringBuilder setPrintDescription(boolean printDescription) {
        this.printDescription = printDescription;
        return this;
    }

    public ToStringBuilder start() {
        this.out.start();
        return this;
    }

    public ToStringBuilder start(String beginQuote, String endQuote) {
        this.out.start(beginQuote, endQuote);
        return this;
    }

    public ToStringBuilder end() {
        this.out.end();
        return this;
    }

    public ToStringBuilder format(String format, Object ... args) {
        this.formatter.format(format, args);
        return this;
    }

    public ToStringBuilder append(boolean value) {
        this.out.append(String.valueOf(value));
        return this;
    }

    public ToStringBuilder append(byte value) {
        this.out.append(String.valueOf(value));
        return this;
    }

    public ToStringBuilder append(char value) {
        this.out.append(value);
        return this;
    }

    public ToStringBuilder append(double value) {
        this.out.append(String.valueOf(value));
        return this;
    }

    public ToStringBuilder append(float value) {
        this.out.append(String.valueOf(value));
        return this;
    }

    public ToStringBuilder append(int value) {
        this.out.append(String.valueOf(value));
        return this;
    }

    public ToStringBuilder append(long value) {
        this.out.append(String.valueOf(value));
        return this;
    }

    public ToStringBuilder append(short value) {
        this.out.append(String.valueOf(value));
        return this;
    }

    public ToStringBuilder appendNull() {
        this.out.append(NULL_STR);
        return this;
    }

    public ToStringBuilder append(Object value) {
        if (value == null) {
            this.appendNull();
        } else if (value instanceof Object[]) {
            this.appendArray((Object[])value);
        } else if (value.getClass().isArray()) {
            this.appendPrimitiveArray(value, -1);
        } else if (value instanceof Collection) {
            this.appendCollection((Collection)value);
        } else if (value instanceof Map) {
            this.appendMap((Map)value);
        } else if (value instanceof StructureBuilder) {
            ((StructureBuilder)value).appendTo(this);
        } else {
            this.out.append(value.toString());
        }
        return this;
    }

    public ToStringBuilder appendDescription(Object value) {
        if (value != null) {
            if (value.getClass().isArray()) {
                this.format("%s[%d]", value.getClass().getComponentType().getCanonicalName(), Array.getLength(value));
            } else {
                this.format("%s@%x", value.getClass().getCanonicalName(), System.identityHashCode(value));
            }
        }
        return this;
    }

    public ToStringBuilder appendHangingIndent(Object value) {
        return this.appendHangingIndent(value, -1);
    }

    private ToStringBuilder appendHangingIndent(Object value, int hangingIndent) {
        this.out.startHangingIndent(hangingIndent);
        this.append(value);
        this.out.end();
        return this;
    }

    public ToStringBuilder appendMap(Map<?, ?> map) {
        return this.appendMap(map, false);
    }

    public ToStringBuilder appendMap(Map<?, ?> map, boolean sort) {
        if (map == null) {
            this.appendNull();
        } else {
            new MapBuilder().setSortKeys(sort).setPrintCount(true).appendAll(map).appendTo(this);
        }
        return this;
    }

    public ToStringBuilder appendCollection(Collection<?> list) {
        return this.appendCollection(list, false);
    }

    public ToStringBuilder appendCollection(Collection<?> list, boolean oneLine) {
        if (list == null) {
            this.appendNull();
        } else {
            new CollectionBuilder().setPrintCount(true).setOneLine(oneLine).appendAll(list).appendTo(this);
        }
        return this;
    }

    public ToStringBuilder appendArray(Object[] list) {
        if (this.isPrintDescription()) {
            this.appendDescription(list);
        }
        return this.appendCollection(CollectionUtil.asList(list));
    }

    public ToStringBuilder appendArray(boolean[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(boolean[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    public ToStringBuilder appendArray(byte[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(byte[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    public ToStringBuilder appendArray(char[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(char[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    public ToStringBuilder appendArray(double[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(double[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    public ToStringBuilder appendArray(float[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(float[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    public ToStringBuilder appendArray(int[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(int[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    public ToStringBuilder appendArray(long[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(long[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    public ToStringBuilder appendArray(short[] list) {
        return this.appendPrimitiveArray(list, -1);
    }

    public ToStringBuilder appendArray(short[] list, int offset, int length) {
        return this.appendPrimitiveArray(list, -1, offset, length);
    }

    private ToStringBuilder appendPrimitiveArray(Object primitiveList, int itemsPerLine) {
        return this.appendPrimitiveArray(primitiveList, itemsPerLine, -1, -1);
    }

    private ToStringBuilder appendPrimitiveArray(Object primitiveList, int itemsPerLine, int offset, int length) {
        if (primitiveList == null) {
            return this.appendNull();
        }
        if (itemsPerLine <= 0) {
            itemsPerLine = 10;
        }
        int arrayLength = Array.getLength(primitiveList);
        if (offset < 0) {
            offset = 0;
        }
        if (length < 0 || offset + length > arrayLength) {
            length = arrayLength - offset;
        }
        int lengthWidth = String.valueOf(length).length();
        String countPattern = "[%0" + lengthWidth + "d-%0" + lengthWidth + "d/%" + lengthWidth + "d] ";
        if (this.isPrintDescription()) {
            this.appendDescription(primitiveList).append(" ");
        }
        if (length == 0) {
            if (!this.isPrintDescription()) {
                this.append("[]");
            }
            return this;
        }
        if (length <= itemsPerLine) {
            this.append("[");
            for (int i = 0; i < length; ++i) {
                this.appendPrimitive(Array.get(primitiveList, i), false);
                if (i >= length - 1) continue;
                this.append(", ");
            }
            this.append("]");
        } else {
            this.start("[", "]");
            int lines = (length + itemsPerLine - 1) / itemsPerLine;
            for (int l = 0; l < lines; ++l) {
                int start = l * itemsPerLine + offset;
                int end = Math.min((l + 1) * itemsPerLine, length) + offset;
                this.format(countPattern, start + 1, end, arrayLength);
                for (int i = start; i < end; ++i) {
                    Object value = Array.get(primitiveList, i);
                    this.appendPrimitive(value, true);
                    if (i >= end - 1) continue;
                    this.format(" ", new Object[0]);
                }
                if (l >= lines - 1) continue;
                this.format("%n", new Object[0]);
            }
            this.end();
        }
        return this;
    }

    private void appendPrimitive(Object value, boolean fixedWidth) {
        String pattern = value instanceof Byte ? (fixedWidth ? "%02x" : "%x") : (value instanceof Boolean ? (fixedWidth ? "%-5s" : "%s") : "%s");
        this.format(pattern, value);
    }

    public String toString() {
        return this.out.toString();
    }

    public static class CollectionBuilder
    implements StructureBuilder {
        private final List<Object> list = CollectionUtil.createLinkedList();
        private boolean sort;
        private boolean printCount;
        private boolean oneLine;

        public CollectionBuilder clear() {
            this.list.clear();
            this.sort = false;
            this.printCount = false;
            this.oneLine = false;
            return this;
        }

        public boolean isSort() {
            return this.sort;
        }

        public CollectionBuilder setSort(boolean sort) {
            this.sort = sort;
            return this;
        }

        public boolean isPrintCount() {
            return this.printCount;
        }

        public CollectionBuilder setPrintCount(boolean printCount) {
            this.printCount = printCount;
            return this;
        }

        public boolean isOneLine() {
            return this.oneLine;
        }

        public CollectionBuilder setOneLine(boolean oneLine) {
            this.oneLine = oneLine;
            return this;
        }

        public CollectionBuilder append(Object value) {
            this.list.add(value);
            return this;
        }

        public CollectionBuilder appendAll(Collection<?> list) {
            if (list != null) {
                for (Object value : list) {
                    this.append(value);
                }
            }
            return this;
        }

        public CollectionBuilder appendAll(Object[] list) {
            return this.appendAll(CollectionUtil.asList(list));
        }

        @Override
        public ToStringBuilder appendTo(ToStringBuilder toStringBuilder) {
            if (this.list.isEmpty()) {
                toStringBuilder.append("[]");
                return toStringBuilder;
            }
            List<Object> list = this.list;
            if (this.sort) {
                list = CollectionUtil.createArrayList(list);
                Collections.sort(list, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof Comparable && o2 instanceof Comparable) {
                            return ((Comparable)o1).compareTo(o2);
                        }
                        return 0;
                    }
                });
            }
            if (this.oneLine) {
                toStringBuilder.append("[");
                Iterator<Object> i = list.iterator();
                while (i.hasNext()) {
                    toStringBuilder.append(i.next());
                    if (!i.hasNext()) continue;
                    toStringBuilder.append(", ");
                }
                toStringBuilder.append("]");
                return toStringBuilder;
            }
            int size = list.size();
            int sizeWidth = String.valueOf(size).length();
            String pattern = "[%" + sizeWidth + "d/" + size + "] ";
            int count = 1;
            toStringBuilder.start("[", "]");
            for (Object value : list) {
                if (this.printCount) {
                    toStringBuilder.format(pattern, count++);
                }
                toStringBuilder.out().startHangingIndent();
                toStringBuilder.append(value);
                toStringBuilder.out().end();
            }
            return toStringBuilder.end();
        }

        public String toString() {
            return this.appendTo(new ToStringBuilder()).toString();
        }
    }

    public static class MapBuilder
    implements StructureBuilder {
        private final Map<String, Object> map = CollectionUtil.createLinkedHashMap();
        private boolean sortKeys;
        private boolean printCount;

        public MapBuilder clear() {
            this.map.clear();
            this.sortKeys = false;
            this.printCount = false;
            return this;
        }

        public boolean isSortKeys() {
            return this.sortKeys;
        }

        public MapBuilder setSortKeys(boolean sortKeys) {
            this.sortKeys = sortKeys;
            return this;
        }

        public boolean isPrintCount() {
            return this.printCount;
        }

        public MapBuilder setPrintCount(boolean printCount) {
            this.printCount = printCount;
            return this;
        }

        public MapBuilder append(String key, Object value) {
            key = ObjectUtil.defaultIfNull(key, ToStringBuilder.NULL_STR);
            this.map.put(key, value);
            return this;
        }

        public MapBuilder appendAll(Map<?, ?> map) {
            if (map != null) {
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    String key = entry.getKey() == null ? ToStringBuilder.NULL_STR : entry.getKey().toString();
                    this.append(key, entry.getValue());
                }
            }
            return this;
        }

        public void remove(String key) {
            this.map.remove(key);
        }

        @Override
        public ToStringBuilder appendTo(ToStringBuilder toStringBuilder) {
            String pattern;
            if (this.map.isEmpty()) {
                toStringBuilder.append("{}");
                return toStringBuilder;
            }
            ArrayList<String> keys = CollectionUtil.createArrayList(this.map.keySet());
            if (this.sortKeys) {
                Collections.sort(keys);
            }
            int maxKeyLength = 0;
            for (String key : keys) {
                maxKeyLength = Math.max(maxKeyLength, key.length());
            }
            if (this.printCount) {
                int size = keys.size();
                int sizeWidth = String.valueOf(size).length();
                pattern = "[%" + sizeWidth + "d/" + size + "] %-" + maxKeyLength + "s = ";
            } else {
                pattern = "%-" + maxKeyLength + "s = ";
            }
            int count = 1;
            toStringBuilder.start("{", "}");
            for (String key : keys) {
                Object value = this.map.get(key);
                if (this.printCount) {
                    toStringBuilder.format(pattern, count++, key);
                } else {
                    toStringBuilder.format(pattern, key);
                }
                toStringBuilder.out().startHangingIndent();
                toStringBuilder.append(value);
                toStringBuilder.out().end();
            }
            return toStringBuilder.end();
        }

        public String toString() {
            return this.appendTo(new ToStringBuilder()).toString();
        }
    }

    public static interface StructureBuilder {
        public ToStringBuilder appendTo(ToStringBuilder var1);
    }
}

