/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.version;

class Version
implements Comparable<Version> {
    private int[] versions;
    private boolean snapshot;
    private String extVersion;

    public Version(String version) {
        String[] string = version.split("-");
        if (string.length == 2) {
            if (string[1].equalsIgnoreCase("snapshot")) {
                this.snapshot = true;
            } else {
                this.extVersion = string[1];
            }
        }
        String[] dStrs = string[0].split("[.]");
        this.versions = new int[dStrs.length];
        for (int i = 0; i < dStrs.length; ++i) {
            this.versions[i] = Integer.valueOf(dStrs[i]);
        }
    }

    public int[] getVersions() {
        return this.versions;
    }

    public void setVersions(int[] versions) {
        this.versions = (int[])versions.clone();
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public int compareTo(Version destVersion) {
        int len = this.versions.length > destVersion.versions.length ? destVersion.versions.length : this.versions.length;
        int ret = 0;
        for (int i = 0; i < len; ++i) {
            if (this.versions[i] < destVersion.versions[i]) {
                ret = -1;
                break;
            }
            if (this.versions[i] <= destVersion.versions[i]) continue;
            ret = 1;
            break;
        }
        if (ret == 0) {
            if (this.versions.length > destVersion.versions.length) {
                ret = 1;
            } else if (this.versions.length < destVersion.versions.length) {
                ret = -1;
            } else {
                if (!this.snapshot && destVersion.snapshot) {
                    return 1;
                }
                if (this.snapshot && !destVersion.snapshot) {
                    return -1;
                }
                if (this.extVersion != null || destVersion.extVersion != null) {
                    throw new RuntimeException("\u4e0d\u80fd\u786e\u5b9a\u7684\u4e24\u4e2a\u7248\u672c.");
                }
            }
        }
        return ret;
    }
}

