/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config.util;

import java.util.List;
import junit.framework.TestCase;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.parser.Node;
import org.tinygroup.xmlparser.node.XmlNode;

public class AppConfigUtilTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetPropertyName() {
        XmlNode appNode = new XmlNode("aa");
        appNode.setAttribute("a", "1");
        appNode.setAttribute("b", "1");
        XmlNode compNode = new XmlNode("aa");
        compNode.setAttribute("b", "2");
        compNode.setAttribute("c", "2");
        AppConfigUtilTest.assertEquals((String)"1", (String)ConfigurationUtil.getPropertyName((XmlNode)appNode, (XmlNode)compNode, (String)"a"));
        AppConfigUtilTest.assertEquals((String)"1", (String)ConfigurationUtil.getPropertyName((XmlNode)appNode, (XmlNode)compNode, (String)"b"));
        AppConfigUtilTest.assertEquals((String)"2", (String)ConfigurationUtil.getPropertyName((XmlNode)appNode, (XmlNode)compNode, (String)"c"));
        AppConfigUtilTest.assertEquals((String)"3", (String)ConfigurationUtil.getPropertyName((XmlNode)appNode, (XmlNode)compNode, (String)"d", (String)"3"));
    }

    public void testCombineSubListXmlNodeXmlNodeStringString() {
        XmlNode appNode = new XmlNode("aa");
        XmlNode compNode = new XmlNode("aa");
        for (int i = 0; i < 3; ++i) {
            appNode.addNode((Node)new XmlNode("aa" + i));
            compNode.addNode((Node)new XmlNode("bb" + i));
        }
        AppConfigUtilTest.assertEquals((int)6, (int)ConfigurationUtil.combineSubList((XmlNode)appNode, (XmlNode)compNode).size());
    }

    public void testCombineSubListXmlNodeXmlNode() {
        XmlNode appNode = new XmlNode("aa");
        XmlNode compNode = new XmlNode("aa");
        for (int i = 0; i < 3; ++i) {
            XmlNode node = new XmlNode("aa");
            node.setAttribute("a", "" + i);
            node.setAttribute("b" + i * i, "" + (i * i + 1));
            appNode.addNode((Node)node);
            XmlNode node2 = new XmlNode("aa");
            node2.setAttribute("a", "" + i);
            node2.setAttribute("b" + i * 2, "" + (i * 2 + 2));
            compNode.addNode((Node)node2);
        }
        List combineSubList = ConfigurationUtil.combineSubList((XmlNode)appNode, (XmlNode)compNode, (String)"aa", (String)"a");
        AppConfigUtilTest.assertEquals((int)3, (int)combineSubList.size());
    }
}

