/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.balance;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.dbrouter.balance.ShardBalance;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardBalanceDefault
implements ShardBalance {
    private Random random = new Random(System.currentTimeMillis());

    @Override
    public List<Shard> getWritableShard(Partition partition) {
        ArrayList<Shard> writableShards = new ArrayList<Shard>();
        for (Shard shard : partition.getWritableShardList()) {
            if (!shard.isWriteAble()) continue;
            writableShards.add(shard);
        }
        if (writableShards.size() == 0) {
            throw new DbrouterRuntimeException("No suitable shard exist.");
        }
        return writableShards;
    }

    @Override
    public Shard getReadableShard(Partition partition) {
        int allWeight = 0;
        Shard selectedShard = partition.getReadShardList().get(0);
        for (Shard shard : partition.getReadShardList()) {
            allWeight += shard.getReadWeight();
        }
        int weightValue = this.randomInt() % allWeight;
        for (Shard shard : partition.getReadShardList()) {
            if ((weightValue -= shard.getReadWeight()) >= 0) continue;
            return shard;
        }
        return selectedShard;
    }

    private int randomInt() {
        int value = this.random.nextInt();
        if (value < 1) {
            value = -value;
        }
        return value;
    }

    @Override
    public Shard getReadShardWithTransaction(Partition partition) {
        List<Shard> writeShard = partition.getWritableShardList();
        if (!CollectionUtil.isEmpty(writeShard)) {
            return writeShard.get(this.randomInt() % writeShard.size());
        }
        return this.getReadableShard(partition);
    }
}

