/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.dbrouter.config.KeyTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="key-tables")
public class KeyTables {
    @XStreamImplicit
    private List<KeyTable> keyTableList;
    private Map<String, Map<String, KeyTable>> keyMap;

    public List<KeyTable> getKeyTableList() {
        if (this.keyTableList == null) {
            this.keyTableList = new ArrayList<KeyTable>();
        }
        return this.keyTableList;
    }

    public void setKeyTableList(List<KeyTable> keyTableList) {
        this.keyTableList = keyTableList;
    }

    public void init() {
        this.keyMap = new HashMap<String, Map<String, KeyTable>>();
        for (KeyTable table : this.getKeyTableList()) {
            Map<String, KeyTable> classMap = this.keyMap.get(table.getLanguage());
            if (classMap == null) {
                classMap = new HashMap<String, KeyTable>();
                this.keyMap.put(table.getLanguage(), classMap);
            }
            classMap.put(table.getClassName(), table);
        }
    }

    public KeyTable getKeyTable(String language, String className) {
        if (this.keyMap.containsKey(language)) {
            return this.keyMap.get(language).get(className);
        }
        return null;
    }
}

