/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.dbrouter.PartitionRule;
import org.tinygroup.dbrouter.config.Router;
import org.tinygroup.dbrouter.config.Shard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="partition")
public class Partition {
    @XStreamAsAttribute
    private String id;
    @XStreamAlias(value="partition-rules")
    private List<PartitionRule> partitionRules;
    @XStreamAlias(value="shards")
    private List<Shard> shards;
    @XStreamAsAttribute
    private int mode;
    public static final int MODE_PRIMARY_SLAVE = 1;
    public static final int MODE_SHARD = 2;
    private transient List<Shard> writableShardList;
    private transient List<Shard> readableShardList;
    private transient Router router;

    public Partition() {
    }

    public Partition(String id, int mode) {
        this.id = id;
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<PartitionRule> getPartitionRules() {
        return this.partitionRules;
    }

    public synchronized List<Shard> getWritableShardList() {
        if (this.writableShardList == null) {
            this.writableShardList = new ArrayList<Shard>();
            for (Shard shard : this.shards) {
                if (!shard.isWriteAble()) continue;
                this.writableShardList.add(shard);
            }
        }
        return this.writableShardList;
    }

    public synchronized List<Shard> getReadShardList() {
        if (this.readableShardList == null) {
            this.readableShardList = new ArrayList<Shard>();
            for (Shard shard : this.shards) {
                if (shard.getReadWeight() <= 0) continue;
                this.readableShardList.add(shard);
            }
        }
        return this.readableShardList;
    }

    public void setPartitionRules(List<PartitionRule> partitionRules) {
        this.partitionRules = partitionRules;
    }

    public List<Shard> getShards() {
        return this.shards;
    }

    public void setShards(List<Shard> shards) {
        this.shards = shards;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }
}

