/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.List;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.dbrouter.RouterKeyGenerator;
import org.tinygroup.dbrouter.config.DataSourceConfig;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="router")
public class Router {
    @XStreamAsAttribute
    private String id;
    @XStreamAlias(value="user-name")
    @XStreamAsAttribute
    private String userName;
    @XStreamAsAttribute
    private String password;
    @XStreamAlias(value="key-generator")
    private RouterKeyGenerator keyGenerator;
    @XStreamAlias(value="data-source-configs")
    private List<DataSourceConfig> dataSources;
    @XStreamAlias(value="partitions")
    private List<Partition> partitions;
    @XStreamAsAttribute
    @XStreamAlias(value="time-out")
    private int timeOut;
    @XStreamAsAttribute
    @XStreamAlias(value="thread-size")
    private int threadSize = 100;
    @XStreamAlias(value="jta-enabled")
    @XStreamAsAttribute
    private boolean jtaEnabled;
    @XStreamAsAttribute
    private String schema;
    @XStreamAsAttribute
    private String catalog;
    private static final int DEFAULT_THREAD_SIZE = 100;

    public Router() {
    }

    public Router(String id, String userName, String password) {
        this.id = id;
        this.userName = userName;
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<DataSourceConfig> getDataSources() {
        return this.dataSources;
    }

    public void setDataSource(List<DataSourceConfig> dataSources) {
        this.dataSources = dataSources;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(List<Partition> partitions) {
        this.partitions = partitions;
        if (!CollectionUtil.isEmpty(partitions)) {
            for (Partition partition : partitions) {
                partition.setRouter(this);
            }
        }
    }

    public DataSourceConfig getDataSourceConfig(String datasourceId) {
        for (DataSourceConfig dataSourceConfig : this.dataSources) {
            if (!datasourceId.equals(dataSourceConfig.getId())) continue;
            return dataSourceConfig;
        }
        throw new DbrouterRuntimeException("\u627e\u4e0d\u5230\u6570\u636e\u6e90\uff1a" + datasourceId);
    }

    public RouterKeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(RouterKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setDataSources(List<DataSourceConfig> dataSources) {
        this.dataSources = dataSources;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public int getThreadSize() {
        if (this.threadSize <= 0) {
            this.threadSize = 100;
        }
        return this.threadSize;
    }

    public void setThreadSize(int threadSize) {
        this.threadSize = threadSize;
    }

    public boolean isJtaEnabled() {
        return this.jtaEnabled;
    }

    public void setJtaEnabled(boolean jtaEnabled) {
        this.jtaEnabled = jtaEnabled;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }
}

