/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.dbrouter.ShardRule;
import org.tinygroup.dbrouter.config.TableMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="shard")
public class Shard {
    private transient Map<Connection, Connection> shardConnection = new HashMap<Connection, Connection>();
    private transient Map<String, String> tableMappingMap = null;
    @XStreamAsAttribute
    private String id;
    @XStreamAlias(value="shard-rules")
    private List<ShardRule> shardRules;
    @XStreamAlias(value="data-source-id")
    @XStreamAsAttribute
    private String dataSourceId;
    @XStreamAsAttribute
    @XStreamAlias(value="read-weight")
    private int readWeight = 10;
    @XStreamAsAttribute
    @XStreamAlias(value="writable")
    private boolean writeAble;
    @XStreamAlias(value="table-mappings")
    private List<TableMapping> tableMappings;

    public Shard() {
    }

    public Shard(String id, String dataSourceId) {
        this.id = id;
        this.dataSourceId = dataSourceId;
    }

    public Shard(String id, String dataSourceId, int readWeight) {
        this.id = id;
        this.dataSourceId = dataSourceId;
        this.readWeight = readWeight;
    }

    public Shard(String id, String dataSourceId, boolean writeAble, int readWeight) {
        this.id = id;
        this.dataSourceId = dataSourceId;
        this.readWeight = readWeight;
        this.writeAble = writeAble;
    }

    public List<TableMapping> getTableMappings() {
        return this.tableMappings;
    }

    public void setTableMappings(List<TableMapping> tableMappings) {
        this.tableMappings = tableMappings;
    }

    public synchronized void setConnection(Connection connection, Connection realConnection) {
        if (this.shardConnection == null) {
            this.shardConnection = new HashMap<Connection, Connection>();
        }
        this.shardConnection.put(connection, realConnection);
    }

    public Connection getConnection(Connection connection) {
        return this.shardConnection.get(connection);
    }

    public void removeConnection(Connection connection) {
        this.shardConnection.remove(connection);
    }

    public int getReadWeight() {
        return this.readWeight;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public void setReadWeight(int readWeight) {
        this.readWeight = readWeight;
    }

    public boolean isWriteAble() {
        return this.writeAble;
    }

    public void setWriteAble(boolean writeAble) {
        this.writeAble = writeAble;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ShardRule> getShardRules() {
        if (this.shardRules == null) {
            this.shardRules = new ArrayList<ShardRule>();
        }
        return this.shardRules;
    }

    public void setShardRules(List<ShardRule> shardRules) {
        this.shardRules = shardRules;
    }

    public String getShardTableName(String tableName) {
        String shardTableName = tableName;
        if (this.tableMappings != null) {
            for (TableMapping mapping : this.tableMappings) {
                if (!mapping.getTableName().equalsIgnoreCase(tableName)) continue;
                shardTableName = mapping.getShardTableName();
                break;
            }
        }
        return shardTableName;
    }

    public Map<String, String> getTableMappingMap() {
        if (this.tableMappings != null && this.tableMappingMap == null) {
            this.tableMappingMap = new HashMap<String, String>();
            for (TableMapping mapping : this.tableMappings) {
                this.tableMappingMap.put(mapping.getTableName(), mapping.getShardTableName());
            }
        }
        return this.tableMappingMap;
    }
}

