/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.context;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Router;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

public class RealStatementExecutor {
    private Statement realStatement;
    private String executeSql;
    private String originalSql;
    private Shard shard;
    private Partition partition;
    private Router router;
    private Object[] values;
    private Logger logger = LoggerFactory.getLogger(RealStatementExecutor.class);

    public RealStatementExecutor(Statement realStatement, String executeSql, String originalSql, Shard shard, Partition partition, Router router, Object[] values) {
        this.realStatement = realStatement;
        this.executeSql = executeSql;
        this.originalSql = originalSql;
        this.partition = partition;
        this.shard = shard;
        this.router = router;
        this.values = values;
    }

    public void addBatch() throws SQLException {
        if (this.realStatement instanceof PreparedStatement) {
            PreparedStatement prepared = (PreparedStatement)this.realStatement;
            prepared.addBatch();
        } else {
            this.realStatement.addBatch(this.executeSql);
        }
    }

    public Statement getRealStatement() {
        return this.realStatement;
    }

    public String getExecuteSql() {
        return this.executeSql;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public Shard getShard() {
        return this.shard;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public Router getRouter() {
        return this.router;
    }

    public Object[] getValues() {
        return this.values;
    }

    public ResultSet executeQuery() throws SQLException {
        this.logger.logMessage(LogLevel.DEBUG, "\u5206\u7247:{0},\u539f\u751fsql:{1}", new Object[]{this.shard.getId(), this.originalSql});
        if (this.realStatement instanceof PreparedStatement) {
            PreparedStatement prepared = (PreparedStatement)this.realStatement;
            return prepared.executeQuery();
        }
        this.logger.logMessage(LogLevel.DEBUG, "\u5206\u7247:{0},\u771f\u5b9e\u6267\u884c\u7684sql:{1}", new Object[]{this.shard.getId(), this.executeSql});
        return this.realStatement.executeQuery(this.executeSql);
    }

    public int executeUpdate() throws SQLException {
        this.logger.logMessage(LogLevel.DEBUG, "\u5206\u7247:{0},\u539f\u751fsql:{1}", new Object[]{this.shard.getId(), this.originalSql});
        if (this.realStatement instanceof PreparedStatement) {
            PreparedStatement prepared = (PreparedStatement)this.realStatement;
            return prepared.executeUpdate();
        }
        this.logger.logMessage(LogLevel.DEBUG, "\u5206\u7247:{0},\u771f\u5b9e\u6267\u884c\u7684sql:{1}", new Object[]{this.shard.getId(), this.executeSql});
        return this.realStatement.executeUpdate(this.executeSql);
    }
}

