/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.context;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.tinygroup.dbrouter.RouterManager;
import org.tinygroup.dbrouter.config.DataSourceConfig;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Router;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.dbrouter.util.OrderByProcessor;
import org.tinygroup.dbrouter.util.SortOrder;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;
import org.tinygroup.jsqlparser.statement.select.Select;
import org.tinygroup.jsqlparser.statement.select.SelectBody;

public class ResultSetExecutor {
    private ResultSet resultSet;
    private String executeSql;
    private String originalSql;
    private boolean isAfterLast;
    private boolean isBeforeFirst;
    private OrderByProcessor orderByProcessor;
    private Shard shard;
    private Partition partition;
    private Router router;
    private RouterManager routerManager = RouterManagerBeanFactory.getManager();

    public ResultSetExecutor(ResultSet resultSet, String executeSql, String originalSql, Shard shard, Partition partition, Router router) throws SQLException {
        this.resultSet = resultSet;
        this.executeSql = executeSql;
        this.originalSql = originalSql;
        this.shard = shard;
        this.router = router;
        this.partition = partition;
        Statement sqlStatement = this.routerManager.getSqlStatement(executeSql);
        if (sqlStatement instanceof Select) {
            Select select = (Select)sqlStatement;
            SelectBody body = select.getSelectBody();
            if (body instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)body;
                this.orderByProcessor = new OrderByProcessor(plainSelect, resultSet);
            }
        } else {
            throw new RuntimeException("must be a query sql");
        }
    }

    public SortOrder getSortOrder() {
        if (this.orderByProcessor == null) {
            return null;
        }
        return this.orderByProcessor.getSortOrder();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public String getExecuteSql() {
        return this.executeSql;
    }

    public boolean[] getOrderTypes() {
        if (this.orderByProcessor != null) {
            return this.orderByProcessor.getOrderTypes();
        }
        return null;
    }

    public int[] getOrderByIndexs() {
        if (this.orderByProcessor != null) {
            return this.orderByProcessor.getOrderByIndexs();
        }
        return null;
    }

    public boolean next() throws SQLException {
        if (!this.isAfterLast) {
            this.isBeforeFirst = false;
            return this.resultSet.next();
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (!this.isBeforeFirst) {
            this.isAfterLast = false;
            return this.resultSet.previous();
        }
        return false;
    }

    public OrderByProcessor.OrderByValues getOrderByValuesFromResultSet() throws SQLException {
        this.orderByProcessor.setValues(this.resultSet);
        return this.orderByProcessor.getValueCache();
    }

    public OrderByProcessor.OrderByValues getValueCache() {
        return this.orderByProcessor.getValueCache();
    }

    public void setValueCache(OrderByProcessor.OrderByValues valueCache) {
        this.orderByProcessor.setValueCache(valueCache);
    }

    public boolean isAfterLast() {
        return this.isAfterLast;
    }

    public void setAfterLast(boolean isAfterLast) {
        this.isAfterLast = isAfterLast;
    }

    public boolean isBeforeFirst() {
        return this.isBeforeFirst;
    }

    public void setBeforeFirst(boolean isBeforeFirst) {
        this.isBeforeFirst = isBeforeFirst;
    }

    public void beforeFirst() throws SQLException {
        this.resultSet.beforeFirst();
        this.orderByProcessor.clearValueCache();
        this.isBeforeFirst = true;
        this.isAfterLast = false;
    }

    public void afterLast() throws SQLException {
        this.resultSet.afterLast();
        this.orderByProcessor.clearValueCache();
        this.isAfterLast = true;
        this.isBeforeFirst = false;
    }

    public void first() throws SQLException {
        this.resultSet.first();
        this.orderByProcessor.clearValueCache();
        this.isAfterLast = false;
        this.isBeforeFirst = false;
    }

    public void last() throws SQLException {
        this.resultSet.last();
        this.orderByProcessor.clearValueCache();
        this.isAfterLast = false;
        this.isBeforeFirst = false;
    }

    public Shard getShard() {
        return this.shard;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public Router getRouter() {
        return this.router;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.router.getDataSourceConfig(this.shard.getDataSourceId());
    }
}

