/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.context;

import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.dbrouter.RouterManager;
import org.tinygroup.dbrouter.StatementProcessor;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Router;
import org.tinygroup.dbrouter.context.RealStatementExecutor;
import org.tinygroup.dbrouter.context.ResultSetExecutor;
import org.tinygroup.dbrouter.factory.RouterManagerBeanFactory;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.dbrouter.util.ParamObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementExecuteContext {
    protected RouterManager routerManager = RouterManagerBeanFactory.getManager();
    private Connection tinyConnection;
    private Statement tinyStatement;
    private String orignalSql;
    private Router router;
    private Partition partition;
    private ParamObjectBuilder builder;
    private boolean isRead;
    private List<RealStatementExecutor> statements;
    private List<ResultSetExecutor> resultSetExecutors;
    private StatementProcessor statementProcessor;

    private void readJudge() {
        if (!StringUtil.isBlank((String)this.orignalSql) && DbRouterUtil.isQuerySql(this.orignalSql)) {
            this.isRead = true;
        }
    }

    public Connection getTinyConnection() {
        return this.tinyConnection;
    }

    public Statement getTinyStatement() {
        return this.tinyStatement;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setTinyConnection(Connection tinyConnection) {
        this.tinyConnection = tinyConnection;
    }

    public void setTinyStatement(Statement tinyStatement) {
        this.tinyStatement = tinyStatement;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public String getOrignalSql() {
        return this.orignalSql;
    }

    public void setOrignalSql(String orignalSql) {
        this.orignalSql = orignalSql;
        this.readJudge();
    }

    public List<RealStatementExecutor> getRealStatements() {
        return this.statements;
    }

    public void setStatements(List<RealStatementExecutor> statements) {
        this.statements = statements;
    }

    public StatementProcessor getStatementProcessor() {
        return this.statementProcessor;
    }

    public void setStatementProcessor(StatementProcessor statementProcessor) {
        this.statementProcessor = statementProcessor;
    }

    public List<ResultSetExecutor> getResultSetExecutors() {
        return this.resultSetExecutors;
    }

    public void setResultSetExecutors(List<ResultSetExecutor> resultSetExecutors) {
        this.resultSetExecutors = resultSetExecutors;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public ParamObjectBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(ParamObjectBuilder builder) {
        this.builder = builder;
    }
}

