/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.factory;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.jcs.JcsCache;
import org.tinygroup.dbrouter.RouterManager;
import org.tinygroup.factory.BeanFactory;
import org.tinygroup.factory.Factory;
import org.tinygroup.factory.config.Beans;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.xstream.XStreamFactory;

public final class RouterManagerBeanFactory {
    public static final String ROUTER_MANAGER = "routerManager";
    private static Factory factory;
    private static RouterManager manager;
    private static Logger logger;
    private static String DEFAULT_REGION;
    private static final String DEFAULT_ROUTER_BEANS_XML = "/defaultbeans.xml";
    private static final String CUSTOM_ROUTER_BEANS_XML = "/custombeans.xml";

    private RouterManagerBeanFactory() {
    }

    public static RouterManager getManager() {
        return RouterManagerBeanFactory.getManager(DEFAULT_REGION);
    }

    public static RouterManager getManager(String region) {
        return RouterManagerBeanFactory.getManager(region, null);
    }

    public static RouterManager getManager(String region, Cache cache) {
        if (manager == null) {
            manager = (RouterManager)factory.getBean(ROUTER_MANAGER);
            Cache orignalCache = manager.getCache();
            if (cache == null && orignalCache == null) {
                cache = new JcsCache();
            } else if (cache == null && orignalCache != null) {
                cache = orignalCache;
            }
            cache.init(region);
            manager.setCache(cache);
        }
        return manager;
    }

    static {
        logger = LoggerFactory.getLogger(RouterManagerBeanFactory.class);
        DEFAULT_REGION = "dbrouter";
        factory = BeanFactory.getFactory();
        XStream xStream = XStreamFactory.getXStream();
        String beansFile = CUSTOM_ROUTER_BEANS_XML;
        InputStream inputStream = RouterManagerBeanFactory.class.getResourceAsStream(CUSTOM_ROUTER_BEANS_XML);
        if (inputStream == null) {
            inputStream = RouterManagerBeanFactory.class.getResourceAsStream(DEFAULT_ROUTER_BEANS_XML);
            beansFile = DEFAULT_ROUTER_BEANS_XML;
        }
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dBean\u914d\u7f6e\u6587\u4ef6{}\u5f00\u59cb...", new Object[]{beansFile});
        try {
            Beans beans = (Beans)xStream.fromXML(inputStream);
            factory.addBeans(beans);
            factory.init();
            logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dBean\u914d\u7f6e\u6587\u4ef6{}\u7ed3\u675f\u3002", new Object[]{beansFile});
        }
        catch (Exception e) {
            logger.errorMessage("\u52a0\u8f7dBean\u914d\u7f6e\u6587\u4ef6{}\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e, new Object[]{beansFile});
        }
    }
}

