/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.insert.Insert;

public class InsertSqlTransform {
    private Insert originalInsert;
    private Shard firstShard;
    private DatabaseMetaData metaData;

    public InsertSqlTransform(Insert originalInsert, Shard firstShard, DatabaseMetaData metaData) {
        this.originalInsert = originalInsert;
        this.firstShard = firstShard;
        this.metaData = metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnInfo getPrimaryColumn() throws SQLException {
        String tableName;
        Table table = this.originalInsert.getTable();
        String queryTableName = tableName = table.getName();
        ResultSet rs = null;
        ColumnInfo columnInfo = null;
        try {
            rs = this.metaData.getPrimaryKeys(null, null, tableName);
            if (rs.next()) {
                columnInfo = this.getPrimaryKeys(rs, table, queryTableName);
            } else {
                rs.close();
                queryTableName = tableName.toUpperCase();
                rs = this.metaData.getPrimaryKeys(null, null, queryTableName);
                if (rs.next()) {
                    columnInfo = this.getPrimaryKeys(rs, table, queryTableName);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return columnInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnInfo getPrimaryKeys(ResultSet rs, Table table, String realTableName) throws SQLException {
        String primaryKey = rs.getString("COLUMN_NAME");
        ResultSet typeRs = this.metaData.getColumns(null, null, realTableName, primaryKey);
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setColumn(new Column(table, primaryKey));
        try {
            if (typeRs.next()) {
                int dataType = typeRs.getInt("DATA_TYPE");
                columnInfo.setDataType(dataType);
            }
        }
        finally {
            if (typeRs != null) {
                typeRs.close();
            }
        }
        return columnInfo;
    }

    public class ColumnInfo
    implements Serializable {
        private static final long serialVersionUID = -8427552991960248458L;
        private Column column;
        private int dataType;

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public int getDataType() {
            return this.dataType;
        }

        public void setDataType(int dataType) {
            this.dataType = dataType;
        }

        public String getColumnName() {
            if (this.column != null) {
                return this.column.getColumnName();
            }
            return null;
        }
    }
}

