/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.cache.Cache;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.dbrouter.PartitionRule;
import org.tinygroup.dbrouter.RouterKeyGenerator;
import org.tinygroup.dbrouter.RouterManager;
import org.tinygroup.dbrouter.ShardRule;
import org.tinygroup.dbrouter.StatementProcessor;
import org.tinygroup.dbrouter.balance.ShardBalance;
import org.tinygroup.dbrouter.balance.ShardBalanceDefault;
import org.tinygroup.dbrouter.config.KeyTable;
import org.tinygroup.dbrouter.config.KeyTables;
import org.tinygroup.dbrouter.config.Partition;
import org.tinygroup.dbrouter.config.Router;
import org.tinygroup.dbrouter.config.Routers;
import org.tinygroup.dbrouter.config.Shard;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.jsqlparser.JSQLParserException;
import org.tinygroup.jsqlparser.parser.CCJSqlParserManager;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.xstream.XStreamFactory;
import org.tinygroup.xstream.config.XStreamAnnotationClass;
import org.tinygroup.xstream.config.XStreamConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterManagerImpl
implements RouterManager {
    private static final String DBCLUSTER_XSTREAM_XML = "/dbrouter.xstream.xml";
    private static Logger logger = LoggerFactory.getLogger(RouterManagerImpl.class);
    private Map<String, Router> routerMap = new ConcurrentHashMap<String, Router>();
    private Map<String, RouterKeyGenerator> routerKeyGeneratorMap = new ConcurrentHashMap<String, RouterKeyGenerator>();
    private CCJSqlParserManager parserManager = new CCJSqlParserManager();
    private Cache cache;
    private ShardBalance balance = new ShardBalanceDefault();
    private List<StatementProcessor> statementProcessorList = new ArrayList<StatementProcessor>();
    private XStream routerXStream;
    private static final String CLUSTER_CONFIG = "dbrouter-config.xml";
    private static final String KEY_TABLE_XSTREAM_XML = "/keygenerator.sqlconfig.xml";
    private KeyTables keyTables;

    public RouterManagerImpl() {
        XStream loadXStream = XStreamFactory.getXStream();
        XStreamConfiguration xstreamConfiguration = (XStreamConfiguration)loadXStream.fromXML(RouterManagerImpl.class.getResourceAsStream(DBCLUSTER_XSTREAM_XML));
        this.routerXStream = XStreamFactory.getXStream((String)xstreamConfiguration.getPackageName());
        try {
            this.initKeyTables();
            this.loadAnnotationClass(this.routerXStream, xstreamConfiguration);
            ClassLoader loader = this.getClass().getClassLoader() == null ? ClassLoader.getSystemClassLoader() : this.getClass().getClassLoader();
            Enumeration<URL> urls = loader.getResources(CLUSTER_CONFIG);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                logger.logMessage(LogLevel.INFO, "\u627e\u5230\u96c6\u7fa4\u914d\u7f6e\u6587\u4ef6\uff1a{0}", new Object[]{url.toString()});
                Routers routers = (Routers)this.routerXStream.fromXML(url);
                this.addRouters(routers);
            }
        }
        catch (ClassNotFoundException e) {
            logger.errorMessage("dbrouter.xstream.xml\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
            throw new DbrouterRuntimeException(e);
        }
        catch (IOException e) {
            logger.errorMessage("\u67e5\u627e\u96c6\u7fa4\u914d\u7f6e:dbrouter-config.xml\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new DbrouterRuntimeException(e);
        }
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean isShardSql(Partition partition, String sql, Object ... preparedParams) {
        if (partition.getMode() == 1) {
            return false;
        }
        if (partition.getShards() != null) {
            for (Shard shard : partition.getShards()) {
                for (ShardRule shardRule : shard.getShardRules()) {
                    if (!shardRule.isMatch(partition, shard, sql, preparedParams)) continue;
                    logger.logMessage(LogLevel.DEBUG, "sql:{0},\u627e\u5230\u5904\u7406\u7684shard:{1},shard-rule:{2}", new Object[]{sql, shard.getId(), shardRule.toString()});
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void addStatementProcessor(StatementProcessor statementProcessor) {
        this.statementProcessorList.add(statementProcessor);
    }

    @Override
    public List<StatementProcessor> getStatementProcessorList() {
        return this.statementProcessorList;
    }

    public void setStatementProcessorList(List<StatementProcessor> statementProcessorList) {
        this.statementProcessorList = statementProcessorList;
    }

    @Override
    public synchronized <T> T getPrimaryKey(Router router, String tableName) {
        RouterKeyGenerator generator = router.getKeyGenerator();
        if (generator != null) {
            generator.setRouter(router);
            return generator.getKey(tableName);
        }
        logger.log(LogLevel.ERROR, "router:{0},\u4e0d\u5b58\u5728key\u83b7\u53d6\u5668:{0}", new Object[]{router.getId()});
        throw new DbrouterRuntimeException("\u4e0d\u5b58\u5728key\u83b7\u53d6\u5668");
    }

    @Override
    public void addRouter(Router router) {
        this.initKeyGenerator(router);
        this.routerMap.put(router.getId(), router);
    }

    private void initKeyTables() {
        try {
            XStream stream = XStreamFactory.getXStream((String)"");
            stream.processAnnotations(new Class[]{KeyTables.class, KeyTable.class});
            this.keyTables = (KeyTables)stream.fromXML(this.getClass().getResourceAsStream(KEY_TABLE_XSTREAM_XML));
            this.keyTables.init();
        }
        catch (Exception e) {
            logger.errorMessage("\u52a0\u8f7d\u4e3b\u952e\u8868\u914d\u7f6e:keygenerator.sqlconfig.xml\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private void initKeyGenerator(Router router) {
        RouterKeyGenerator keyGenerator = router.getKeyGenerator();
        if (keyGenerator == null || !keyGenerator.isAutoCreate()) {
            return;
        }
        logger.logMessage(LogLevel.DEBUG, "router:{0},\u6267\u884c\u52a8\u6001\u521b\u5efa\u4e3b\u952e\u5b58\u50a8\u8868\u5f00\u59cb", new Object[]{router.getId()});
        keyGenerator.setRouter(router);
        keyGenerator.createKeyTable(this.keyTables);
        logger.logMessage(LogLevel.DEBUG, "router:{0},\u6267\u884c\u52a8\u6001\u521b\u5efa\u4e3b\u952e\u5b58\u50a8\u8868\u7ed3\u675f", new Object[]{router.getId()});
    }

    @Override
    public Router getRouter(String routerId) {
        return this.routerMap.get(routerId);
    }

    @Override
    public boolean isMatch(Partition partition, String sql) {
        List<PartitionRule> rules = partition.getPartitionRules();
        if (rules == null) {
            return true;
        }
        for (PartitionRule rule : rules) {
            if (!rule.isMatch(sql)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatch(Partition partition, Shard shard, String sql, Object ... preparedParams) {
        List<ShardRule> rules = shard.getShardRules();
        if (rules == null || rules.size() == 0) {
            return true;
        }
        for (ShardRule rule : rules) {
            if (!rule.isMatch(partition, shard, sql, preparedParams)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSql(Partition partition, Shard shard, String sql, Object ... preparedParams) {
        List<ShardRule> rules = shard.getShardRules();
        for (ShardRule rule : rules) {
            if (!rule.isMatch(partition, shard, sql, preparedParams)) continue;
            return rule.getReplacedSql(partition, shard, sql);
        }
        if (!CollectionUtil.isEmpty(shard.getTableMappings())) {
            return DbRouterUtil.transformSqlWithTableName(sql, shard.getTableMappingMap());
        }
        return sql;
    }

    @Override
    public Collection<Partition> getPartitions(String routerId, String sql) {
        Router router = this.getRouter(routerId);
        return this.getPartitions(router, sql);
    }

    @Override
    public Partition getPartition(String routerId, String sql) {
        return this.getPartition(this.getRouter(routerId), sql);
    }

    @Override
    public Partition getPartition(Router router, String sql) {
        if (router != null) {
            for (Partition partition : router.getPartitions()) {
                if (!this.isMatch(partition, sql)) continue;
                return partition;
            }
        }
        throw new DbrouterRuntimeException("\u4e0d\u80fd\u627e\u5230SQL:" + sql + "\u5339\u914d\u7684\u5206\u533a\uff01");
    }

    @Override
    public List<Partition> getPartitions(Router router, String sql) {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (router != null) {
            for (Partition partition : router.getPartitions()) {
                if (!this.isMatch(partition, sql)) continue;
                partitions.add(partition);
            }
        }
        return partitions;
    }

    @Override
    public List<Shard> getShards(Partition partition, String sql, Object ... preparedParams) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        if (partition != null && !CollectionUtil.isEmpty(partition.getShards())) {
            for (Shard shard : partition.getShards()) {
                if (!this.isMatch(partition, shard, sql, preparedParams)) continue;
                shards.add(shard);
            }
        }
        return shards;
    }

    @Override
    public Statement getSqlStatement(String sql) {
        Statement statement = null;
        try {
            statement = (Statement)this.cache.get(sql);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (statement != null) {
            return statement;
        }
        try {
            statement = this.parserManager.parse((Reader)new StringReader(sql));
            this.cache.put(sql, (Object)statement);
        }
        catch (JSQLParserException e) {
            throw new DbrouterRuntimeException(e);
        }
        return statement;
    }

    @Override
    public ShardBalance getShardBalance() {
        return this.balance;
    }

    @Override
    public void setShardBalance(ShardBalance balance) {
        this.balance = balance;
    }

    @Override
    public void addRouters(String routerFilePath) {
        this.addRouters(RouterManagerImpl.class.getResourceAsStream(routerFilePath));
    }

    @Override
    public void addRouters(InputStream inputStream) {
        Routers routers = (Routers)this.routerXStream.fromXML(inputStream);
        this.addRouters(routers);
    }

    @Override
    public void addRouters(Routers routers) {
        for (Router router : routers.getRouterList()) {
            this.addRouter(router);
        }
    }

    private void loadAnnotationClass(XStream xStream, XStreamConfiguration xstreamConfiguration) throws ClassNotFoundException {
        if (xstreamConfiguration.getxStreamAnnotationClasses() != null) {
            for (XStreamAnnotationClass annotationClass : xstreamConfiguration.getxStreamAnnotationClasses()) {
                xStream.processAnnotations(Class.forName(annotationClass.getClassName()));
            }
        }
    }

    @Override
    public Map<String, Router> getRouterMap() {
        return this.routerMap;
    }
}

