/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.dbrouter.impl.keygenerator;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.dbrouter.RouterKeyGenerator;
import org.tinygroup.dbrouter.config.DataSourceConfig;
import org.tinygroup.dbrouter.config.KeyTable;
import org.tinygroup.dbrouter.config.KeyTables;
import org.tinygroup.dbrouter.config.Router;
import org.tinygroup.dbrouter.exception.DbrouterRuntimeException;
import org.tinygroup.dbrouter.impl.keygenerator.KeyTableInstallProcessor;
import org.tinygroup.dbrouter.util.DbRouterUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRouterKeyGenerator<T extends Number>
implements RouterKeyGenerator<T> {
    protected static final String END_NUMBER = "end_number";
    protected transient Router router;
    private transient Connection connection = null;
    protected transient Map<String, KeyConfigArea> caches = new HashMap<String, KeyConfigArea>();
    private static Logger logger = LoggerFactory.getLogger(AbstractRouterKeyGenerator.class);
    private static final int DEFAULT_STEP = 100;
    public static final String DEFAULT_KEY_TABLE_NAME = "key_table";
    @XStreamAlias(value="increment")
    @XStreamAsAttribute
    private int increment = 1;
    @XStreamAlias(value="key-table-name")
    @XStreamAsAttribute
    private String keyTableName = "key_table";
    private int step = 100;
    @XStreamAlias(value="data-source-id")
    @XStreamAsAttribute
    private String dataSourceId;
    @XStreamAlias(value="auto-create")
    @XStreamAsAttribute
    private boolean autoCreate = false;

    public String getKeyTableName() {
        if (this.keyTableName == null) {
            this.keyTableName = DEFAULT_KEY_TABLE_NAME;
        }
        return this.keyTableName;
    }

    public void setKeyTableName(String keyTableName) {
        this.keyTableName = keyTableName;
    }

    public int getIncrement() {
        if (this.increment == 0) {
            this.increment = 1;
        }
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getStep() {
        if (this.step == 0) {
            this.step = 100;
        }
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    @Override
    public void createKeyTable(KeyTables keyTables) {
        DataSourceConfig dataSourceConfig = this.router.getDataSourceConfig(this.getDataSourceId());
        String language = DbRouterUtil.getLanguageByUrl(dataSourceConfig.getUrl());
        KeyTable keyTable = keyTables.getKeyTable(language, this.getClass().getName());
        if (keyTable == null) {
            logger.logMessage(LogLevel.ERROR, "router:{0},\u67e5\u627elanguage:{1},\u7c7b\u578b:{2}\u7684\u4e3b\u952e\u8868\u914d\u7f6e\u5931\u8d25", new Object[]{this.router.getId(), language, this.getClass().getName()});
            return;
        }
        KeyTableInstallProcessor tableInstallProcessor = new KeyTableInstallProcessor();
        tableInstallProcessor.setKeyTable(keyTable);
        tableInstallProcessor.setTableName(this.getKeyTableName());
        tableInstallProcessor.setDataSourceConfig(dataSourceConfig);
        tableInstallProcessor.process(language);
    }

    @Override
    public T getKey(String tableName) {
        KeyConfigArea area;
        if (this.caches == null) {
            this.caches = new HashMap<String, KeyConfigArea>();
        }
        if ((area = this.caches.get(tableName)) == null) {
            area = new KeyConfigArea();
            this.updateKey(tableName, area, new WithNoResultCallBack(){

                public void callback(String tableName, Statement statement) throws SQLException {
                    String sql = "insert into " + AbstractRouterKeyGenerator.this.getKeyTableName() + "(end_number,table_name) values(" + AbstractRouterKeyGenerator.this.getStep() + ",'" + tableName + "')";
                    statement.executeUpdate(sql);
                }
            });
            this.caches.put(tableName, area);
        }
        if (area.checkUpdateKey()) {
            this.updateKey(tableName, area, new WithNoResultCallBack(){

                public void callback(String tableName, Statement statement) throws SQLException {
                    throw new DbrouterRuntimeException("\u96c6\u7fa4\u4e3b\u952e\u8868:" + AbstractRouterKeyGenerator.this.getKeyTableName() + "\u67e5\u8be2\u4e0d\u5230" + tableName + "\u7684\u8bb0\u5f55");
                }
            });
        }
        long nowCurrentNumber = area.getCurrentNumber() + (long)this.getIncrement();
        area.setCurrentNumber(nowCurrentNumber);
        return this.generatorNextKey(nowCurrentNumber);
    }

    private synchronized void updateKey(String tableName, KeyConfigArea area, WithNoResultCallBack callback) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = DbRouterUtil.createConnection(this.router.getDataSourceConfig(this.getDataSourceId()));
            }
            String generatorTableName = this.getKeyTableName();
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery("select * from " + generatorTableName + " where table_name='" + tableName + "'");
            if (resultSet.next()) {
                long oldEndNumber = resultSet.getLong(END_NUMBER);
                long newEndNumber = oldEndNumber + (long)this.getStep();
                String sql = "update " + generatorTableName + " set end_number=" + newEndNumber + " where table_name='" + tableName + "'";
                statement.executeUpdate(sql);
                area.setCurrentNumber(oldEndNumber);
                area.setEndNumber(newEndNumber);
            } else {
                callback.callback(tableName, statement);
                area.setEndNumber(this.getStep());
                area.setCurrentNumber(0L);
            }
        }
        catch (SQLException e) {
            logger.errorMessage("\u83b7\u53d6\u8868" + tableName + "\u7684\u4e3b\u952e\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException ex) {
                    logger.errorMessage("\u5173\u95ed\u8fde\u63a5\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)ex);
                    throw new DbrouterRuntimeException(ex);
                }
            }
            throw new DbrouterRuntimeException(e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException ex) {
                logger.errorMessage(ex.getMessage(), (Throwable)ex);
                throw new DbrouterRuntimeException(ex);
            }
        }
    }

    protected abstract T generatorNextKey(Long var1);

    @Override
    public void setRouter(Router router) {
        this.router = router;
    }

    static interface WithNoResultCallBack {
        public void callback(String var1, Statement var2) throws SQLException;
    }

    class KeyConfigArea {
        private long currentNumber;
        private long endNumber;

        KeyConfigArea() {
        }

        public long getCurrentNumber() {
            return this.currentNumber;
        }

        public void setCurrentNumber(long currentNumber) {
            this.currentNumber = currentNumber;
        }

        public long getEndNumber() {
            return this.endNumber;
        }

        public void setEndNumber(long endNumber) {
            this.endNumber = endNumber;
        }

        public boolean checkUpdateKey() {
            return this.currentNumber + (long)AbstractRouterKeyGenerator.this.getIncrement() - this.endNumber > 0L;
        }
    }
}

